/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.ForeignKeyInformation;
import org.hibernate.tool.schema.extract.spi.IndexInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaMigrator;
import org.hibernate.tool.schema.spi.Target;

public class SchemaMigratorImpl
implements SchemaMigrator {
    private UniqueConstraintSchemaUpdateStrategy uniqueConstraintStrategy;

    @Override
    public void doMigration(Metadata metadata, DatabaseInformation existingDatabase, boolean createNamespaces, List<Target> targets) throws SchemaManagementException {
        for (Target target : targets) {
            target.prepare();
        }
        this.doMigrationToTargets(metadata, existingDatabase, createNamespaces, targets);
        for (Target target : targets) {
            target.release();
        }
    }

    protected void doMigrationToTargets(Metadata metadata, DatabaseInformation existingDatabase, boolean createNamespaces, List<Target> targets) {
        TableInformation tableInformation;
        HashSet<String> exportIdentifiers = new HashSet<String>(50);
        Database database = metadata.getDatabase();
        JdbcEnvironment jdbcEnvironment = database.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaMigratorImpl.applySqlStrings(dialect.getAuxiliaryDatabaseObjectExporter().getSqlDropStrings(auxiliaryDatabaseObject, metadata), targets, true);
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaMigratorImpl.applySqlStrings(auxiliaryDatabaseObject.sqlCreateStrings(jdbcEnvironment.getDialect()), targets, true);
        }
        boolean tryToCreateCatalogs = false;
        boolean tryToCreateSchemas = false;
        if (createNamespaces) {
            if (database.getJdbcEnvironment().getDialect().canCreateSchema()) {
                tryToCreateSchemas = true;
            }
            if (database.getJdbcEnvironment().getDialect().canCreateCatalog()) {
                tryToCreateCatalogs = true;
            }
        }
        HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
        for (Namespace namespace : database.getNamespaces()) {
            if (tryToCreateCatalogs || tryToCreateSchemas) {
                if (tryToCreateCatalogs) {
                    Identifier catalogLogicalName = namespace.getName().getCatalog();
                    Identifier catalogPhysicalName = namespace.getPhysicalName().getCatalog();
                    if (catalogPhysicalName != null && !exportedCatalogs.contains(catalogLogicalName) && !existingDatabase.catalogExists(catalogLogicalName)) {
                        SchemaMigratorImpl.applySqlStrings(database.getJdbcEnvironment().getDialect().getCreateCatalogCommand(catalogPhysicalName.render(database.getJdbcEnvironment().getDialect())), targets, false);
                        exportedCatalogs.add(catalogLogicalName);
                    }
                }
                if (tryToCreateSchemas && namespace.getPhysicalName().getSchema() != null && !existingDatabase.schemaExists(namespace.getName())) {
                    SchemaMigratorImpl.applySqlStrings(database.getJdbcEnvironment().getDialect().getCreateSchemaCommand(namespace.getPhysicalName().getSchema().render(database.getJdbcEnvironment().getDialect())), targets, false);
                }
            }
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable()) continue;
                this.checkExportIdentifier(table, exportIdentifiers);
                tableInformation = existingDatabase.getTableInformation(table.getQualifiedTableName());
                if (tableInformation != null && !tableInformation.isPhysicalTable()) continue;
                if (tableInformation == null) {
                    this.createTable(table, metadata, targets);
                    continue;
                }
                this.migrateTable(table, tableInformation, targets, metadata);
            }
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable() || (tableInformation = existingDatabase.getTableInformation(table.getQualifiedTableName())) != null && !tableInformation.isPhysicalTable()) continue;
                this.applyIndexes(table, tableInformation, metadata, targets);
                this.applyUniqueKeys(table, tableInformation, metadata, targets);
            }
            for (Sequence sequence : namespace.getSequences()) {
                this.checkExportIdentifier(sequence, exportIdentifiers);
                SequenceInformation sequenceInformation = existingDatabase.getSequenceInformation(sequence.getName());
                if (sequenceInformation != null) continue;
                SchemaMigratorImpl.applySqlStrings(database.getJdbcEnvironment().getDialect().getSequenceExporter().getSqlCreateStrings(sequence, metadata), targets, false);
            }
        }
        for (Namespace namespace : database.getNamespaces()) {
            for (Table table : namespace.getTables()) {
                tableInformation = existingDatabase.getTableInformation(table.getQualifiedTableName());
                if (tableInformation != null && !tableInformation.isPhysicalTable()) continue;
                this.applyForeignKeys(table, tableInformation, metadata, targets);
            }
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaMigratorImpl.applySqlStrings(auxiliaryDatabaseObject.sqlCreateStrings(jdbcEnvironment.getDialect()), targets, true);
        }
    }

    private void createTable(Table table, Metadata metadata, List<Target> targets) {
        SchemaMigratorImpl.applySqlStrings(metadata.getDatabase().getDialect().getTableExporter().getSqlCreateStrings(table, metadata), targets, false);
    }

    private void migrateTable(Table table, TableInformation tableInformation, List<Target> targets, Metadata metadata) {
        Database database = metadata.getDatabase();
        JdbcEnvironment jdbcEnvironment = database.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        SchemaMigratorImpl.applySqlStrings(table.sqlAlterStrings(dialect, metadata, tableInformation, this.getDefaultCatalogName(database), this.getDefaultSchemaName(database)), targets, false);
    }

    private void applyIndexes(Table table, TableInformation tableInformation, Metadata metadata, List<Target> targets) {
        Exporter<Index> exporter = metadata.getDatabase().getJdbcEnvironment().getDialect().getIndexExporter();
        Iterator<Index> indexItr = table.getIndexIterator();
        while (indexItr.hasNext()) {
            IndexInformation existingIndex;
            Index index = indexItr.next();
            if (StringHelper.isEmpty(index.getName()) || tableInformation != null && (existingIndex = this.findMatchingIndex(index, tableInformation)) != null) continue;
            SchemaMigratorImpl.applySqlStrings(exporter.getSqlCreateStrings(index, metadata), targets, false);
        }
    }

    private IndexInformation findMatchingIndex(Index index, TableInformation tableInformation) {
        return tableInformation.getIndex(Identifier.toIdentifier(index.getName()));
    }

    private void applyUniqueKeys(Table table, TableInformation tableInfo, Metadata metadata, List<Target> targets) {
        if (this.uniqueConstraintStrategy == null) {
            this.uniqueConstraintStrategy = this.determineUniqueConstraintSchemaUpdateStrategy(metadata);
        }
        if (this.uniqueConstraintStrategy == UniqueConstraintSchemaUpdateStrategy.SKIP) {
            return;
        }
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        Exporter<Constraint> exporter = dialect.getUniqueKeyExporter();
        Iterator<UniqueKey> ukItr = table.getUniqueKeyIterator();
        while (ukItr.hasNext()) {
            IndexInformation indexInfo;
            UniqueKey uniqueKey = ukItr.next();
            if (tableInfo != null && StringHelper.isNotEmpty(uniqueKey.getName()) && (indexInfo = tableInfo.getIndex(Identifier.toIdentifier(uniqueKey.getName()))) != null) continue;
            if (this.uniqueConstraintStrategy == UniqueConstraintSchemaUpdateStrategy.DROP_RECREATE_QUIETLY) {
                SchemaMigratorImpl.applySqlStrings(exporter.getSqlDropStrings(uniqueKey, metadata), targets, true);
            }
            SchemaMigratorImpl.applySqlStrings(exporter.getSqlCreateStrings(uniqueKey, metadata), targets, true);
        }
    }

    private UniqueConstraintSchemaUpdateStrategy determineUniqueConstraintSchemaUpdateStrategy(Metadata metadata) {
        ConfigurationService cfgService = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry().getService(ConfigurationService.class);
        return UniqueConstraintSchemaUpdateStrategy.interpret(cfgService.getSetting("hibernate.schema_update.unique_constraint_strategy", StandardConverters.STRING));
    }

    private void applyForeignKeys(Table table, TableInformation tableInformation, Metadata metadata, List<Target> targets) {
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        if (!dialect.hasAlterTable()) {
            return;
        }
        Exporter<ForeignKey> exporter = dialect.getForeignKeyExporter();
        Iterator fkItr = table.getForeignKeyIterator();
        while (fkItr.hasNext()) {
            ForeignKeyInformation existingForeignKey;
            ForeignKey foreignKey = (ForeignKey)fkItr.next();
            if (!foreignKey.isPhysicalConstraint() || !foreignKey.isCreationEnabled() || tableInformation != null && (existingForeignKey = this.findMatchingForeignKey(foreignKey, tableInformation)) != null) continue;
            SchemaMigratorImpl.applySqlStrings(exporter.getSqlCreateStrings(foreignKey, metadata), targets, false);
        }
    }

    private ForeignKeyInformation findMatchingForeignKey(ForeignKey foreignKey, TableInformation tableInformation) {
        if (foreignKey.getName() == null) {
            return null;
        }
        return tableInformation.getForeignKey(Identifier.toIdentifier(foreignKey.getName()));
    }

    private void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException(String.format("Export identifier [%s] encountered more than once", exportIdentifier));
        }
        exportIdentifiers.add(exportIdentifier);
    }

    private static void applySqlStrings(String[] sqlStrings, List<Target> targets, boolean quiet) {
        if (sqlStrings == null) {
            return;
        }
        for (String sqlString : sqlStrings) {
            SchemaMigratorImpl.applySqlString(sqlString, targets, quiet);
        }
    }

    private static void applySqlString(String sqlString, List<Target> targets, boolean quiet) {
        if (sqlString == null) {
            return;
        }
        for (Target target : targets) {
            try {
                target.accept(sqlString);
            }
            catch (SchemaManagementException e) {
                if (quiet) continue;
                throw e;
            }
        }
    }

    private static void applySqlStrings(Iterator<String> sqlStrings, List<Target> targets, boolean quiet) {
        if (sqlStrings == null) {
            return;
        }
        while (sqlStrings.hasNext()) {
            String sqlString = sqlStrings.next();
            SchemaMigratorImpl.applySqlString(sqlString, targets, quiet);
        }
    }

    private String getDefaultCatalogName(Database database) {
        Identifier identifier = database.getDefaultNamespace().getPhysicalName().getCatalog();
        return identifier == null ? null : identifier.render(database.getJdbcEnvironment().getDialect());
    }

    private String getDefaultSchemaName(Database database) {
        Identifier identifier = database.getDefaultNamespace().getPhysicalName().getSchema();
        return identifier == null ? null : identifier.render(database.getJdbcEnvironment().getDialect());
    }
}

