/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.wsf.spi.management.EndpointMetrics;

public class EndpointMetricsImpl
implements EndpointMetrics {
    private volatile boolean started = false;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock r = this.lock.readLock();
    private final Lock w = this.lock.writeLock();
    private final AtomicLong requestCount = new AtomicLong(0L);
    private final AtomicLong responseCount = new AtomicLong(0L);
    private final AtomicLong faultCount = new AtomicLong(0L);
    private final AtomicLong maxProcessingTime = new AtomicLong(0L);
    private final AtomicLong minProcessingTime = new AtomicLong(0L);
    private final AtomicLong totalProcessingTime = new AtomicLong(0L);

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public long processRequestMessage() {
        if (!this.started) {
            return 0L;
        }
        this.requestCount.incrementAndGet();
        return System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponseMessage(long beginTime) {
        if (beginTime > 0L) {
            long procTime = System.nanoTime() - beginTime;
            this.r.lock();
            try {
                this.responseCount.incrementAndGet();
                this.totalProcessingTime.addAndGet(procTime);
            }
            finally {
                this.r.unlock();
            }
            this.minProcessingTime.compareAndSet(0L, procTime);
            this.updateMax(this.maxProcessingTime, procTime);
            this.updateMin(this.minProcessingTime, procTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFaultMessage(long beginTime) {
        if (beginTime > 0L) {
            long procTime = System.nanoTime() - beginTime;
            this.r.lock();
            try {
                this.faultCount.incrementAndGet();
                this.totalProcessingTime.addAndGet(procTime);
            }
            finally {
                this.r.unlock();
            }
            this.minProcessingTime.compareAndSet(0L, procTime);
            this.updateMax(this.maxProcessingTime, procTime);
            this.updateMin(this.minProcessingTime, procTime);
        }
    }

    private void updateMin(AtomicLong min, long value) {
        long oldValue = min.get();
        while (value < oldValue && !min.compareAndSet(oldValue, value)) {
            oldValue = min.get();
        }
    }

    private void updateMax(AtomicLong max, long value) {
        long oldValue = max.get();
        while (value > oldValue && !max.compareAndSet(oldValue, value)) {
            oldValue = max.get();
        }
    }

    public long getMinProcessingTime() {
        return this.minProcessingTime.longValue() / 1000000L;
    }

    public long getMaxProcessingTime() {
        return this.maxProcessingTime.longValue() / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAverageProcessingTime() {
        this.w.lock();
        try {
            long totResponses = this.responseCount.get() + this.faultCount.get();
            long l = totResponses != 0L ? this.totalProcessingTime.get() / (totResponses * 1000000L) : 0L;
            return l;
        }
        finally {
            this.w.unlock();
        }
    }

    public long getTotalProcessingTime() {
        return this.totalProcessingTime.get() / 1000000L;
    }

    public long getRequestCount() {
        return this.requestCount.get();
    }

    public long getFaultCount() {
        return this.faultCount.get();
    }

    public long getResponseCount() {
        return this.responseCount.get();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("requestCount=" + this.requestCount);
        buffer.append("\n  responseCount=" + this.responseCount);
        buffer.append("\n  faultCount=" + this.faultCount);
        buffer.append("\n  maxProcessingTime=" + this.maxProcessingTime);
        buffer.append("\n  minProcessingTime=" + this.minProcessingTime);
        buffer.append("\n  avgProcessingTime=" + this.getAverageProcessingTime());
        buffer.append("\n  totalProcessingTime=" + this.totalProcessingTime);
        return buffer.toString();
    }
}

