/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.embedded;

import javax.management.MBeanServer;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManagerImpl;

public class EmbeddedActiveMQ {
    protected ActiveMQSecurityManager securityManager;
    protected String configResourcePath = null;
    protected Configuration configuration;
    protected ActiveMQServer activeMQServer;
    protected MBeanServer mbeanServer;

    public void setConfigResourcePath(String filename) {
        this.configResourcePath = filename;
    }

    public void setSecurityManager(ActiveMQSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public ActiveMQServer getActiveMQServer() {
        return this.activeMQServer;
    }

    public void start() throws Exception {
        this.initStart();
        this.activeMQServer.start();
    }

    protected void initStart() throws Exception {
        if (this.configuration == null) {
            if (this.configResourcePath == null) {
                this.configResourcePath = "broker.xml";
            }
            FileDeploymentManager deploymentManager = new FileDeploymentManager(this.configResourcePath);
            FileConfiguration config = new FileConfiguration();
            deploymentManager.addDeployable(config);
            deploymentManager.readConfiguration();
            this.configuration = config;
        }
        if (this.securityManager == null) {
            this.securityManager = new ActiveMQSecurityManagerImpl();
        }
        this.activeMQServer = this.mbeanServer == null ? new ActiveMQServerImpl(this.configuration, this.securityManager) : new ActiveMQServerImpl(this.configuration, this.mbeanServer, this.securityManager);
    }

    public void stop() throws Exception {
        this.activeMQServer.stop();
    }
}

