/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego.encoding;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jboss.security.negotiation.spnego.encoding.NegTokenEncoder;
import org.jboss.security.negotiation.spnego.encoding.NegTokenTarg;

public class NegTokenTargEncoder
extends NegTokenEncoder {
    protected static int getTotalLength(List<byte[]> tokens) {
        int length = 0;
        for (byte[] current : tokens) {
            length += current.length;
        }
        return length;
    }

    protected static void encodeNegTokenTarg(List<byte[]> tokens) {
        byte[] constructedSequence = NegTokenTargEncoder.createTypeLength((byte)-95, NegTokenTargEncoder.getTotalLength(tokens));
        tokens.add(0, constructedSequence);
    }

    protected static void encodeConstructedSequence(List<byte[]> tokens) {
        byte[] constructedSequence = NegTokenTargEncoder.createTypeLength((byte)48, NegTokenTargEncoder.getTotalLength(tokens));
        tokens.add(0, constructedSequence);
    }

    protected static void encodeNegResult(List<byte[]> tokens, Integer negResult) {
        if (negResult == null) {
            return;
        }
        byte result = NegTokenTarg.ACCEPT_COMPLETED.equals(negResult) ? (byte)0 : (NegTokenTarg.ACCEPT_INCOMPLETE.equals(negResult) ? (byte)1 : 2);
        byte[] negResultToken = new byte[]{-96, 3, 10, 1, result};
        tokens.add(0, negResultToken);
    }

    protected static void encodeSupportedMech(List<byte[]> tokens, Oid supportedMech) throws GSSException {
        if (supportedMech == null) {
            return;
        }
        byte[] supportedMechToken = supportedMech.getDER();
        byte[] sequenceLength = NegTokenTargEncoder.createTypeLength((byte)-95, supportedMechToken.length);
        tokens.add(0, supportedMechToken);
        tokens.add(0, sequenceLength);
    }

    protected static void encodeResponseToken(List<byte[]> tokens, byte[] responseToken) {
        if (responseToken == null || responseToken.length == 0) {
            return;
        }
        byte[] octletLength = NegTokenTargEncoder.createTypeLength((byte)4, responseToken.length);
        byte[] sequenceLength = NegTokenTargEncoder.createTypeLength((byte)-94, responseToken.length + octletLength.length);
        tokens.add(0, responseToken);
        tokens.add(0, octletLength);
        tokens.add(0, sequenceLength);
    }

    protected static void encodeMechListMIC(List<byte[]> tokens, byte[] mechListMIC) {
        if (mechListMIC == null || mechListMIC.length == 0) {
            return;
        }
        byte[] octletLength = NegTokenTargEncoder.createTypeLength((byte)4, mechListMIC.length);
        byte[] sequenceLength = NegTokenTargEncoder.createTypeLength((byte)-93, mechListMIC.length + octletLength.length);
        tokens.add(0, mechListMIC);
        tokens.add(0, octletLength);
        tokens.add(0, sequenceLength);
    }

    protected static void contructMessage(List<byte[]> tokens, OutputStream os) throws IOException {
        int length = NegTokenTargEncoder.getTotalLength(tokens);
        Iterator<byte[]> it = tokens.iterator();
        while (it.hasNext()) {
            os.write(it.next());
        }
    }

    public static void encode(NegTokenTarg negTokenTarg, OutputStream os) throws GSSException, IOException {
        LinkedList<byte[]> tokens = new LinkedList<byte[]>();
        NegTokenTargEncoder.encodeMechListMIC(tokens, negTokenTarg.getMechListMIC());
        NegTokenTargEncoder.encodeResponseToken(tokens, negTokenTarg.getResponseToken());
        NegTokenTargEncoder.encodeSupportedMech(tokens, negTokenTarg.getSupportedMech());
        NegTokenTargEncoder.encodeNegResult(tokens, negTokenTarg.getNegResult());
        NegTokenTargEncoder.encodeConstructedSequence(tokens);
        NegTokenTargEncoder.encodeNegTokenTarg(tokens);
        NegTokenTargEncoder.contructMessage(tokens, os);
    }

    public static byte[] encode(NegTokenTarg negTokenTarg) throws GSSException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NegTokenTargEncoder.encode(negTokenTarg, baos);
        return baos.toByteArray();
    }
}

