/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.modules.ModuleLoader;
import org.jgroups.Channel;
import org.jgroups.fork.ForkChannel;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;

public class ForkChannelFactory
implements ChannelFactory {
    private final ChannelFactory parentFactory;
    private final List<ProtocolConfiguration> protocols;
    private final Channel channel;

    public ForkChannelFactory(Channel channel, ChannelFactory parentFactory, List<ProtocolConfiguration> protocols) {
        this.channel = channel;
        this.parentFactory = parentFactory;
        this.protocols = protocols;
    }

    public ForkChannelFactory(Channel channel, ChannelFactory parentFactory, ProtocolConfiguration ... protocols) {
        this(channel, parentFactory, Arrays.asList(protocols));
    }

    public Channel createChannel(String id) throws Exception {
        JGroupsLogger.ROOT_LOGGER.debugf("Creating fork channel %s from channel %s", id, this.channel.getClusterName());
        String stackName = this.protocols.isEmpty() ? this.channel.getClusterName() : id;
        ForkProtocolStackConfiguration forkStack = new ForkProtocolStackConfiguration(stackName, this.parentFactory.getProtocolStackConfiguration(), this.protocols);
        List protocols = Configurator.createProtocols(JChannelFactory.createProtocols(forkStack, this.channel.getProtocolStack().getTransport().isMulticastCapable()), (ProtocolStack)new ProtocolStack());
        return new ForkChannel(this.channel, stackName, id, protocols.toArray(new Protocol[protocols.size()]));
    }

    public ProtocolStackConfiguration getProtocolStackConfiguration() {
        List parentProtocols = this.parentFactory.getProtocolStackConfiguration().getProtocols();
        ArrayList<ProtocolConfiguration> protocols = new ArrayList<ProtocolConfiguration>(parentProtocols.size() + this.protocols.size());
        protocols.addAll(parentProtocols);
        protocols.addAll(this.protocols);
        return new ForkProtocolStackConfiguration(this.channel.getClusterName(), this.parentFactory.getProtocolStackConfiguration(), protocols);
    }

    public boolean isUnknownForkResponse(ByteBuffer response) {
        return this.parentFactory.isUnknownForkResponse(response);
    }

    private static class ForkProtocolStackConfiguration
    implements ProtocolStackConfiguration {
        private final String name;
        private final List<ProtocolConfiguration> protocols;
        private final ProtocolStackConfiguration parentStack;

        ForkProtocolStackConfiguration(String name, ProtocolStackConfiguration parentStack, List<ProtocolConfiguration> protocols) {
            this.name = name;
            this.protocols = protocols;
            this.parentStack = parentStack;
        }

        public String getName() {
            return this.name;
        }

        public List<ProtocolConfiguration> getProtocols() {
            return this.protocols;
        }

        public Map<String, String> getDefaultProperties(String protocol) {
            return this.parentStack.getDefaultProperties(protocol);
        }

        public TransportConfiguration getTransport() {
            return this.parentStack.getTransport();
        }

        public ModuleLoader getModuleLoader() {
            return this.parentStack.getModuleLoader();
        }

        public String getNodeName() {
            return this.parentStack.getNodeName();
        }

        public RelayConfiguration getRelay() {
            return this.parentStack.getRelay();
        }
    }
}

