/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.HandlerOperations;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.as.logging.validators.Validators;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.handlers.SyslogHandler;

class SyslogHandlerResourceDefinition
extends TransformerResourceDefinition {
    static final String SYSLOG_HANDLER = "syslog-handler";
    static final PathElement SYSLOG_HANDLER_PATH = PathElement.pathElement((String)"syslog-handler");
    static final PropertyAttributeDefinition APP_NAME = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("app-name", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setPropertyName("appName").setValidator((ParameterValidator)Validators.NOT_EMPTY_NULLABLE_STRING_VALIDATOR)).build();
    static final PropertyAttributeDefinition FACILITY = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("facility", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(FacilityAttribute.USER_LEVEL.toString()))).setResolver(FacilityResolver.INSTANCE).setValidator((ParameterValidator)EnumValidator.create(FacilityAttribute.class, (boolean)true, (boolean)true))).build();
    static final PropertyAttributeDefinition HOSTNAME = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("hostname", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setValidator((ParameterValidator)Validators.NOT_EMPTY_NULLABLE_STRING_VALIDATOR)).build();
    static final PropertyAttributeDefinition PORT = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("port", ModelType.INT, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(514))).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true))).build();
    static final PropertyAttributeDefinition SERVER_ADDRESS = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("server-address", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode("localhost"))).setPropertyName("serverHostname").setValidator((ParameterValidator)Validators.NOT_EMPTY_NULLABLE_STRING_VALIDATOR)).build();
    static final PropertyAttributeDefinition SYSLOG_FORMATTER = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("syslog-format", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(AbstractHandlerDefinition.FORMATTER.getXmlName());
                writer.writeStartElement(attribute.getXmlName());
                String content = resourceModel.get(attribute.getName()).asString();
                writer.writeAttribute(Attribute.SYSLOG_TYPE.getLocalName(), content);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    })).setDefaultValue(new ModelNode(SyslogHandler.SyslogType.RFC5424.name()))).setPropertyName("syslogType").setValidator((ParameterValidator)EnumValidator.create(SyslogHandler.SyslogType.class, (boolean)true, (boolean)true))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{APP_NAME, CommonAttributes.ENABLED, FACILITY, HOSTNAME, CommonAttributes.LEVEL, PORT, SERVER_ADDRESS, SYSLOG_FORMATTER};
    static final HandlerOperations.HandlerAddOperationStepHandler ADD_HANDLER = new HandlerOperations.HandlerAddOperationStepHandler(SyslogHandler.class, ATTRIBUTES);
    static final HandlerOperations.LogHandlerWriteAttributeHandler WRITE_HANDLER = new HandlerOperations.LogHandlerWriteAttributeHandler(ATTRIBUTES);
    static final SyslogHandlerResourceDefinition INSTANCE = new SyslogHandlerResourceDefinition();

    public SyslogHandlerResourceDefinition() {
        super(SYSLOG_HANDLER_PATH, LoggingExtension.getResourceDescriptionResolver(SYSLOG_HANDLER), ADD_HANDLER, HandlerOperations.REMOVE_HANDLER);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)WRITE_HANDLER);
        }
    }

    @Override
    public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
    }

    static class FacilityResolver
    implements ModelNodeResolver<String> {
        static final FacilityResolver INSTANCE = new FacilityResolver();

        FacilityResolver() {
        }

        @Override
        public String resolveValue(OperationContext context, ModelNode value) throws OperationFailedException {
            return FacilityAttribute.fromString(value.asString()).getFacility().name();
        }
    }

    static enum FacilityAttribute {
        KERNEL("kernel"),
        USER_LEVEL("user-level"),
        MAIL_SYSTEM("mail-system"),
        SYSTEM_DAEMONS("system-daemons"),
        SECURITY("security"),
        SYSLOGD("syslogd"),
        LINE_PRINTER("line-printer"),
        NETWORK_NEWS("network-news"),
        UUCP("uucp"),
        CLOCK_DAEMON("clock-daemon"),
        SECURITY2("security2"),
        FTP_DAEMON("ftp-daemon"),
        NTP("ntp"),
        LOG_AUDIT("log-audit"),
        LOG_ALERT("log-alert"),
        CLOCK_DAEMON2("clock-daemon2"),
        LOCAL_USE_0("local-use-0"),
        LOCAL_USE_1("local-use-1"),
        LOCAL_USE_2("local-use-2"),
        LOCAL_USE_3("local-use-3"),
        LOCAL_USE_4("local-use-4"),
        LOCAL_USE_5("local-use-5"),
        LOCAL_USE_6("local-use-6"),
        LOCAL_USE_7("local-use-7");

        private static final Map<String, FacilityAttribute> MAP;
        private final SyslogHandler.Facility facility;
        private final String value;

        private FacilityAttribute(String value) {
            this.value = value;
            this.facility = SyslogHandler.Facility.valueOf((String)value.replace("-", "_").toUpperCase(Locale.ENGLISH));
        }

        public SyslogHandler.Facility getFacility() {
            return this.facility;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        static FacilityAttribute fromString(String value) {
            return MAP.get(value);
        }

        static {
            MAP = new HashMap<String, FacilityAttribute>();
            for (FacilityAttribute facilityAttribute : FacilityAttribute.values()) {
                MAP.put(facilityAttribute.toString(), facilityAttribute);
            }
        }
    }
}

