/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.AddWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkExecutor;
import org.hibernate.search.backend.impl.lucene.works.UpdateWorkExecutor;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ByTermUpdateWorkExecutor
extends UpdateWorkExecutor {
    private static final Log log = LoggerFactory.make();
    private final AddWorkExecutor addDelegate;
    private final Workspace workspace;

    ByTermUpdateWorkExecutor(Workspace workspace, AddWorkExecutor addDelegate) {
        super(null, null);
        this.workspace = workspace;
        this.addDelegate = addDelegate;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        Serializable id = work.getId();
        String tenantId = work.getTenantId();
        Class<?> managedType = work.getEntityClass();
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(managedType);
        try {
            if (DeleteWorkExecutor.isIdNumeric(builder)) {
                log.tracef("Deleting %s#%s by query using an IndexWriter#updateDocument as id is Numeric", managedType, id);
                Query exactMatchQuery = NumericFieldUtils.createExactMatchQuery(builder.getIdKeywordName(), id);
                BooleanQuery deleteDocumentsQuery = new BooleanQuery();
                deleteDocumentsQuery.add(exactMatchQuery, BooleanClause.Occur.FILTER);
                if (tenantId != null) {
                    TermQuery tenantTermQuery = new TermQuery(new Term("__HSearch_TenantId", tenantId));
                    deleteDocumentsQuery.add((Query)tenantTermQuery, BooleanClause.Occur.FILTER);
                }
                delegate.deleteDocuments((Query)deleteDocumentsQuery);
                this.addDelegate.performWork(work, delegate, monitor);
            } else {
                log.tracef("Updating %s#%s by id using an IndexWriter#updateDocument.", managedType, id);
                Term idTerm = new Term(builder.getIdKeywordName(), work.getIdInString());
                Map<String, String> fieldToAnalyzerMap = work.getFieldToAnalyzerMap();
                ScopedAnalyzer analyzer = builder.getAnalyzer();
                analyzer = AddWorkExecutor.updateAnalyzerMappings(this.workspace, analyzer, fieldToAnalyzerMap);
                delegate.updateDocument(idTerm, work.getDocument(), analyzer);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to update " + managedType + "#" + id + " in index.";
            throw new SearchException(message, e);
        }
        if (monitor != null) {
            monitor.documentsAdded(1L);
        }
    }
}

