/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl.nullencoding;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.nullencoding.NullMarkerCodec;

public class KeywordBasedNullCodec
implements NullMarkerCodec {
    private final String indexNullAs;
    private final BytesRef encodedToken;

    public KeywordBasedNullCodec(String indexNullAs) {
        if (indexNullAs == null) {
            throw new NullPointerException("The constructor parameter is mandatory");
        }
        this.indexNullAs = indexNullAs;
        this.encodedToken = new BytesRef((CharSequence)indexNullAs);
    }

    @Override
    public String nullRepresentedAsString() {
        return this.indexNullAs;
    }

    @Override
    public void encodeNullValue(String name, Document document, LuceneOptions luceneOptions) {
        luceneOptions.addFieldToDocument(name, this.indexNullAs, document);
    }

    @Override
    public Query createNullMatchingQuery(String fieldName) {
        return new TermQuery(new Term(fieldName, this.encodedToken));
    }

    @Override
    public boolean representsNullValue(IndexableField field) {
        String stringValue = field.stringValue();
        return this.indexNullAs.equals(stringValue);
    }
}

