/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.Builder;

public abstract class StoreBuilder
extends CacheComponentBuilder<PersistenceConfiguration>
implements ResourceServiceBuilder<PersistenceConfiguration> {
    private final InjectedValue<AsyncStoreConfiguration> async = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private volatile StoreConfigurationBuilder<?, ?> storeBuilder;

    StoreBuilder(String containerName, String cacheName) {
        super(CacheComponent.PERSISTENCE, containerName, cacheName);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.STORE_WRITE.getServiceName(this.containerName, this.cacheName), AsyncStoreConfiguration.class, this.async);
    }

    public Builder<PersistenceConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.storeBuilder = this.createStore(context, model);
        this.storeBuilder.persistence().passivation(StoreResourceDefinition.Attribute.PASSIVATION.getDefinition().resolveModelAttribute(context, model).asBoolean());
        ((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)this.storeBuilder.fetchPersistentState(StoreResourceDefinition.Attribute.FETCH_STATE.getDefinition().resolveModelAttribute(context, model).asBoolean())).preload(StoreResourceDefinition.Attribute.PRELOAD.getDefinition().resolveModelAttribute(context, model).asBoolean())).purgeOnStartup(StoreResourceDefinition.Attribute.PURGE.getDefinition().resolveModelAttribute(context, model).asBoolean())).shared(StoreResourceDefinition.Attribute.SHARED.getDefinition().resolveModelAttribute(context, model).asBoolean())).singleton().enabled(StoreResourceDefinition.Attribute.SINGLETON.getDefinition().resolveModelAttribute(context, model).asBoolean()).withProperties(ModelNodes.asProperties((ModelNode)StoreResourceDefinition.Attribute.PROPERTIES.getDefinition().resolveModelAttribute(context, model)));
        return this;
    }

    abstract StoreConfigurationBuilder<?, ?> createStore(OperationContext var1, ModelNode var2) throws OperationFailedException;

    public PersistenceConfiguration getValue() {
        return this.storeBuilder.async().read((AsyncStoreConfiguration)this.async.getValue()).persistence().create();
    }
}

