/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ThreadMXBeanFindDeadlockedThreadsHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("find-deadlocked-threads", (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("threading")).setReplyType(ModelType.LIST).setReplyValueType(ModelType.LONG).setRuntimeOnly().setReadOnly().allowReturnNull().build();
    public static final ThreadMXBeanFindDeadlockedThreadsHandler INSTANCE = new ThreadMXBeanFindDeadlockedThreadsHandler();

    private ThreadMXBeanFindDeadlockedThreadsHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            long[] ids = ManagementFactory.getThreadMXBean().findDeadlockedThreads();
            ModelNode result = context.getResult();
            if (ids != null) {
                result.setEmptyList();
                for (long id : ids) {
                    result.add(id);
                }
            }
        }
        catch (SecurityException e) {
            throw new OperationFailedException(e.toString());
        }
    }
}

