/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.UUID;
import org.hibernate.cache.infinispan.util.FutureUpdate;
import org.hibernate.cache.infinispan.util.InvocationAfterCompletion;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.infinispan.AdvancedCache;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class FutureUpdateSynchronization
extends InvocationAfterCompletion {
    private static final Log log = LogFactory.getLog(FutureUpdateSynchronization.class);
    private final UUID uuid = UUID.randomUUID();
    private final Object key;
    private final Object value;

    public FutureUpdateSynchronization(TransactionCoordinator tc, AdvancedCache cache, boolean requiresTransaction, Object key, Object value) {
        super(tc, cache, requiresTransaction);
        this.key = key;
        this.value = value;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    protected void invoke(boolean success, AdvancedCache cache) {
        while (true) {
            try {
                cache.put(this.key, (Object)new FutureUpdate(this.uuid, success ? this.value : null));
                return;
            }
            catch (Exception e) {
                log.error((Object)"Failure updating cache in afterCompletion, will retry", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

