/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

class EJBRemoteTransactionPropagatingInterceptor
implements Interceptor {
    private final EJBRemoteTransactionsRepository ejbRemoteTransactionsRepository;

    EJBRemoteTransactionPropagatingInterceptor(EJBRemoteTransactionsRepository ejbRemoteTransactionsRepository) {
        this.ejbRemoteTransactionsRepository = ejbRemoteTransactionsRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        TransactionManager transactionManager = this.ejbRemoteTransactionsRepository.getTransactionManager();
        Transaction originatingRemoteTx = null;
        TransactionID transactionID = (TransactionID)context.getPrivateData((Object)AttachmentKeys.TRANSACTION_ID_KEY);
        if (transactionID != null) {
            if (transactionID instanceof UserTransactionID) {
                this.createOrResumeUserTransaction((UserTransactionID)transactionID);
            } else if (transactionID instanceof XidTransactionID) {
                this.createOrResumeXidTransaction((XidTransactionID)transactionID);
            }
            originatingRemoteTx = transactionManager.getTransaction();
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (originatingRemoteTx != null) {
                transactionManager.suspend();
            }
        }
    }

    private void createOrResumeUserTransaction(UserTransactionID userTransactionID) throws Exception {
        TransactionManager transactionManager = this.ejbRemoteTransactionsRepository.getTransactionManager();
        Transaction alreadyCreatedTx = this.ejbRemoteTransactionsRepository.getUserTransaction(userTransactionID);
        if (alreadyCreatedTx != null) {
            transactionManager.resume(alreadyCreatedTx);
            return;
        }
        this.ejbRemoteTransactionsRepository.beginUserTransaction(userTransactionID);
    }

    private void createOrResumeXidTransaction(XidTransactionID xidTransactionID) throws Exception {
        TransactionManager transactionManager = this.ejbRemoteTransactionsRepository.getTransactionManager();
        SubordinateTransaction alreadyCreatedTx = this.ejbRemoteTransactionsRepository.getImportedTransaction(xidTransactionID);
        if (alreadyCreatedTx != null) {
            transactionManager.resume((Transaction)alreadyCreatedTx);
        } else {
            Transaction newSubOrdinateTx = this.ejbRemoteTransactionsRepository.importTransaction(xidTransactionID, Integer.getInteger("org.jboss.as.ejb3.remote-tx-timeout", 31536000));
            transactionManager.resume(newSubOrdinateTx);
        }
    }
}

