/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3Subsystem12Parser;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.RemoteConnectorChannelCreationOptionResource;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class EJB3Subsystem13Parser
extends EJB3Subsystem12Parser {
    public static final EJB3Subsystem13Parser INSTANCE = new EJB3Subsystem13Parser();

    protected EJB3Subsystem13Parser() {
    }

    @Override
    protected void readElement(XMLExtendedStreamReader reader, EJB3SubsystemXMLElement element, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        switch (element) {
            case DEFAULT_DISTINCT_NAME: {
                this.parseDefaultDistinctName(reader, ejb3SubsystemAddOperation);
                break;
            }
            case STATISTICS: {
                this.parseStatistics(reader, ejb3SubsystemAddOperation);
                break;
            }
            default: {
                super.readElement(reader, element, operations, ejb3SubsystemAddOperation);
            }
        }
    }

    @Override
    protected EJB3SubsystemNamespace getExpectedNamespace() {
        return EJB3SubsystemNamespace.EJB3_1_3;
    }

    private void parseStatistics(XMLExtendedStreamReader reader, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.ENABLED);
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    EJB3SubsystemRootResourceDefinition.ENABLE_STATISTICS.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    missingRequiredAttributes.remove((Object)EJB3SubsystemXMLAttribute.ENABLED);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
    }

    private void parseDefaultDistinctName(XMLExtendedStreamReader reader, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.VALUE);
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    EJB3SubsystemRootResourceDefinition.DEFAULT_DISTINCT_NAME.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    missingRequiredAttributes.remove((Object)EJB3SubsystemXMLAttribute.VALUE);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
    }

    @Override
    protected void parseRemote(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.CONNECTOR_REF, EJB3SubsystemXMLAttribute.THREAD_POOL_NAME);
        PathAddress ejb3RemoteServiceAddress = SUBSYSTEM_PATH.append("service", "remote");
        ModelNode operation = Util.createAddOperation((PathAddress)ejb3RemoteServiceAddress);
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CONNECTOR_REF: {
                    EJB3RemoteResourceDefinition.CONNECTOR_REF.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                case THREAD_POOL_NAME: {
                    EJB3RemoteResourceDefinition.THREAD_POOL_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        operation.get("execute-in-worker").set(new ModelNode(false));
        operations.add(operation);
        HashSet<EJB3SubsystemXMLElement> parsedElements = new HashSet<EJB3SubsystemXMLElement>();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case CHANNEL_CREATION_OPTIONS: {
                    if (parsedElements.contains((Object)EJB3SubsystemXMLElement.CHANNEL_CREATION_OPTIONS)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    parsedElements.add(EJB3SubsystemXMLElement.CHANNEL_CREATION_OPTIONS);
                    this.parseChannelCreationOptions(reader, ejb3RemoteServiceAddress, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseChannelCreationOptions(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case OPTION: {
                    this.parseChannelCreationOption(reader, address, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseChannelCreationOption(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations) throws XMLStreamException {
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.NAME, EJB3SubsystemXMLAttribute.TYPE);
        int count = reader.getAttributeCount();
        String optionName = null;
        ModelNode operation = Util.createAddOperation();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attributeValue = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    optionName = attributeValue;
                    continue block5;
                }
                case TYPE: {
                    RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_TYPE.parseAndSetParameter(attributeValue, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case VALUE: {
                    RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_VALUE.parseAndSetParameter(attributeValue, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operation.get("address").set(address.append("channel-creation-options", optionName).toModelNode());
        operations.add(operation);
    }
}

