/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.narayana.compensations.api.CompensationScoped;
import org.jboss.narayana.compensations.api.CompensationTransactionRuntimeException;
import org.jboss.narayana.compensations.impl.BAControllerFactory;

public class CompensationContext
implements Context {
    private static final Map<Object, Map<String, Object>> beanStorePerTransaction = new HashMap<Object, Map<String, Object>>();
    private static ThreadLocal<Object> txContextToExtend = new ThreadLocal();

    public Class<? extends Annotation> getScope() {
        return CompensationScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (contextual == null) {
            throw new RuntimeException("contextual is null");
        }
        PassivationCapable bean = (PassivationCapable)contextual;
        Map beans = this.getBeansForThisTransaction();
        Object resource = beans.get(bean.getId());
        if (resource != null) {
            return (T)resource;
        }
        if (creationalContext != null) {
            Object t = contextual.create(creationalContext);
            beans.put(bean.getId(), t);
            return (T)t;
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    private Map getBeansForThisTransaction() {
        try {
            Object currentTX = txContextToExtend.get();
            if (currentTX == null) {
                currentTX = BAControllerFactory.getInstance().getCurrentTransaction();
            }
            if (beanStorePerTransaction.get(currentTX) == null) {
                beanStorePerTransaction.put(currentTX, new HashMap());
            }
            return beanStorePerTransaction.get(currentTX);
        }
        catch (Exception e) {
            throw new CompensationTransactionRuntimeException("Error looking up Transaction", e);
        }
    }

    public boolean isActive() {
        if (txContextToExtend.get() != null) {
            return true;
        }
        try {
            Object currentTX = BAControllerFactory.getInstance().getCurrentTransaction();
            return currentTX != null;
        }
        catch (Exception e) {
            throw new CompensationTransactionRuntimeException("Error looking up Transaction", e);
        }
    }

    public static void setTxContextToExtend(Object currentTX) {
        txContextToExtend.set(currentTX);
    }

    public static void close(Object currentTX) {
        txContextToExtend.set(null);
        beanStorePerTransaction.remove(currentTX);
    }
}

