/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.as.weld.services.bootstrap.JTSSynchronizationWrapper;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.transaction.spi.TransactionServices;

public class WeldTransactionServices
implements TransactionServices,
Service<WeldTransactionServices> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldTransactionServices"});
    private final InjectedValue<UserTransaction> injectedTransaction = new InjectedValue();
    private final InjectedValue<TransactionManager> injectedTransactionManager = new InjectedValue();
    private final boolean jtsEnabled;

    public WeldTransactionServices(boolean jtsEnabled) {
        this.jtsEnabled = jtsEnabled;
    }

    public UserTransaction getUserTransaction() {
        return (UserTransaction)this.injectedTransaction.getValue();
    }

    public boolean isTransactionActive() {
        try {
            int status = ((TransactionManager)this.injectedTransactionManager.getValue()).getStatus();
            return status == 0 || status == 8 || status == 1 || status == 2 || status == 7 || status == 9;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
    }

    public void registerSynchronization(Synchronization synchronizedObserver) {
        try {
            Object synchronization = !this.jtsEnabled ? synchronizedObserver : new JTSSynchronizationWrapper(synchronizedObserver);
            ((TransactionManager)this.injectedTransactionManager.getValue()).getTransaction().registerSynchronization(synchronization);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        catch (RollbackException e) {
            throw new RuntimeException(e);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public WeldTransactionServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<UserTransaction> getInjectedTransaction() {
        return this.injectedTransaction;
    }

    public InjectedValue<TransactionManager> getInjectedTransactionManager() {
        return this.injectedTransactionManager;
    }
}

