/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.TransformUtils;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.iiop.openjdk.IIOPSubsystemAdd;
import org.wildfly.iiop.openjdk.PropertiesMap;

public class JacORBSubsystemAdd
extends IIOPSubsystemAdd {
    static final JacORBSubsystemAdd INSTANCE = new JacORBSubsystemAdd();

    private JacORBSubsystemAdd() {
        super(JacORBSubsystemDefinitions.SUBSYSTEM_ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode legacyModel) throws OperationFailedException {
        this.printJacORBEmulationWarningMessage();
        super.performRuntime(context, operation, legacyModel);
    }

    private void printJacORBEmulationWarningMessage() {
        JacORBLogger.ROOT_LOGGER.jacorbEmulationWarning();
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        List<String> unsupportedProperites;
        super.populateModel(context, operation, resource);
        ModelNode model = resource.getModel();
        boolean adminOnly = context.getRunningMode() == RunningMode.ADMIN_ONLY;
        boolean hostController = context.getProcessType().equals((Object)ProcessType.HOST_CONTROLLER);
        if (!(!adminOnly && hostController || (unsupportedProperites = TransformUtils.checkLegacyModel(model)).isEmpty())) {
            if (adminOnly) {
                String warning = JacORBLogger.ROOT_LOGGER.cannotEmulatePropertiesWarning(unsupportedProperites);
                JacORBLogger.ROOT_LOGGER.warn(warning);
            } else {
                throw JacORBLogger.ROOT_LOGGER.cannotEmulateProperties(unsupportedProperites);
            }
        }
    }

    protected Properties getConfigurationProperties(OperationContext context, ModelNode model) throws OperationFailedException {
        Object value;
        String name;
        Properties props = new Properties();
        for (AttributeDefinition attrDefinition : JacORBSubsystemDefinitions.SUBSYSTEM_ATTRIBUTES) {
            ModelNode resolvedModelAttribute;
            if (JacORBSubsystemDefinitions.ON_OFF_ATTRIBUTES_TO_REJECT.contains(attrDefinition) || JacORBSubsystemDefinitions.ATTRIBUTES_TO_REJECT.contains(attrDefinition) || !(resolvedModelAttribute = attrDefinition.resolveModelAttribute(context, model)).isDefined()) continue;
            name = attrDefinition.getName();
            value = resolvedModelAttribute.asString();
            String openjdkProperty = (String)PropertiesMap.PROPS_MAP.get(name);
            if (openjdkProperty != null) {
                name = openjdkProperty;
            }
            props.setProperty(name, (String)value);
        }
        if (model.hasDefined("properties")) {
            ModelNode propertiesNode = model.get("properties");
            for (Property property : propertiesNode.asPropertyList()) {
                name = property.getName();
                value = property.getValue();
                props.setProperty(name, value.asString());
            }
        }
        return props;
    }
}

