/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.HandlerUtil;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

public class AuditLogHandlerReferenceResourceDefinition
extends SimpleResourceDefinition {
    static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"handler");

    public AuditLogHandlerReferenceResourceDefinition(ManagedAuditLogger auditLogger, boolean executeRuntime) {
        super(PATH_ELEMENT, DomainManagementResolver.getDeprecatedResolver("core.management.audit-log", "core.management.audit-log.handler-reference"), (OperationStepHandler)new AuditLogHandlerReferenceAddHandler(auditLogger, executeRuntime), (OperationStepHandler)new AuditLogHandlerReferenceRemoveHandler(auditLogger, executeRuntime));
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
    }

    private static class AuditLogHandlerReferenceRemoveHandler
    extends AbstractRemoveStepHandler {
        private final ManagedAuditLogger auditLogger;
        private final boolean executeRuntime;

        AuditLogHandlerReferenceRemoveHandler(ManagedAuditLogger auditLogger, boolean executeRuntime) {
            this.auditLogger = auditLogger;
            this.executeRuntime = executeRuntime;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return this.executeRuntime;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().removeHandlerReference(PathAddress.pathAddress((ModelNode)operation.require("address")));
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }

    private static class AuditLogHandlerReferenceAddHandler
    extends AbstractAddStepHandler {
        private final ManagedAuditLogger auditLogger;
        private final boolean executeRuntime;

        AuditLogHandlerReferenceAddHandler(ManagedAuditLogger auditLogger, boolean executeRuntime) {
            this.auditLogger = auditLogger;
            this.executeRuntime = executeRuntime;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            String name;
            PathAddress addr = PathAddress.pathAddress((ModelNode)operation.require("address"));
            if (!HandlerUtil.lookForHandler(context, addr, name = addr.getLastElement().getValue())) {
                throw DomainManagementLogger.ROOT_LOGGER.noHandlerCalled(name);
            }
            resource.getModel().setEmptyObject();
        }

        protected boolean requiresRuntime(OperationContext context) {
            return this.executeRuntime;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().addHandlerReference(PathAddress.pathAddress((ModelNode)operation.require("address")));
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }
}

