/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;

public class PKIndexSplitter {
    private final Query docsInFirstIndex;
    private final Directory input;
    private final Directory dir1;
    private final Directory dir2;
    private final IndexWriterConfig config1;
    private final IndexWriterConfig config2;

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Query docsInFirstIndex) {
        this(input, dir1, dir2, docsInFirstIndex, PKIndexSplitter.newDefaultConfig(), PKIndexSplitter.newDefaultConfig());
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Filter docsInFirstIndex) {
        this(input, dir1, dir2, (Query)docsInFirstIndex);
    }

    private static IndexWriterConfig newDefaultConfig() {
        return new IndexWriterConfig(null).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Query docsInFirstIndex, IndexWriterConfig config1, IndexWriterConfig config2) {
        this.input = input;
        this.dir1 = dir1;
        this.dir2 = dir2;
        this.docsInFirstIndex = docsInFirstIndex;
        this.config1 = config1;
        this.config2 = config2;
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Filter docsInFirstIndex, IndexWriterConfig config1, IndexWriterConfig config2) {
        this(input, dir1, dir2, (Query)docsInFirstIndex, config1, config2);
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Term midTerm) {
        this(input, dir1, dir2, (Query)new TermRangeQuery(midTerm.field(), null, midTerm.bytes(), true, false));
    }

    public PKIndexSplitter(Directory input, Directory dir1, Directory dir2, Term midTerm, IndexWriterConfig config1, IndexWriterConfig config2) {
        this(input, dir1, dir2, (Query)new TermRangeQuery(midTerm.field(), null, midTerm.bytes(), true, false), config1, config2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split() throws IOException {
        block5: {
            DirectoryReader reader;
            block4: {
                boolean success = false;
                reader = DirectoryReader.open((Directory)this.input);
                try {
                    this.createIndex(this.config1, this.dir1, reader, this.docsInFirstIndex, false);
                    this.createIndex(this.config2, this.dir2, reader, this.docsInFirstIndex, true);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{reader});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{reader});
                break block5;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(IndexWriterConfig config, Directory target, DirectoryReader reader, Query preserveFilter, boolean negateFilter) throws IOException {
        block6: {
            IndexWriter w;
            block5: {
                boolean success = false;
                w = new IndexWriter(target, config);
                try {
                    IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                    searcher.setQueryCache(null);
                    boolean needsScores = false;
                    Weight preserveWeight = searcher.createNormalizedWeight(preserveFilter, false);
                    List leaves = reader.leaves();
                    CodecReader[] subReaders = new CodecReader[leaves.size()];
                    int i = 0;
                    for (LeafReaderContext ctx : leaves) {
                        subReaders[i++] = new DocumentFilteredLeafIndexReader(ctx, preserveWeight, negateFilter);
                    }
                    w.addIndexes(subReaders);
                    success = true;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        w.close();
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{w});
                    }
                    throw throwable;
                }
                w.close();
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{w});
        }
    }

    private static class DocumentFilteredLeafIndexReader
    extends FilterCodecReader {
        final Bits liveDocs;
        final int numDocs;

        public DocumentFilteredLeafIndexReader(LeafReaderContext context, Weight preserveWeight, boolean negateFilter) throws IOException {
            super((CodecReader)context.reader());
            int maxDoc = this.in.maxDoc();
            FixedBitSet bits = new FixedBitSet(maxDoc);
            Scorer preserveIt = preserveWeight.scorer(context);
            if (preserveIt != null) {
                bits.or((DocIdSetIterator)preserveIt);
            }
            if (negateFilter) {
                bits.flip(0, maxDoc);
            }
            if (this.in.hasDeletions()) {
                Bits oldLiveDocs = this.in.getLiveDocs();
                assert (oldLiveDocs != null);
                BitSetIterator it = new BitSetIterator((BitSet)bits, 0L);
                int i = it.nextDoc();
                while (i != Integer.MAX_VALUE) {
                    if (!oldLiveDocs.get(i)) {
                        bits.clear(i);
                    }
                    i = it.nextDoc();
                }
            }
            this.liveDocs = bits;
            this.numDocs = bits.cardinality();
        }

        public int numDocs() {
            return this.numDocs;
        }

        public Bits getLiveDocs() {
            return this.liveDocs;
        }
    }
}

