/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerAddHandler;
import org.wildfly.extension.picketlink.idm.service.PartitionManagerService;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class IdentityStoreRemoveStepHandler
extends RestartParentResourceRemoveHandler {
    static final IdentityStoreRemoveStepHandler INSTANCE = new IdentityStoreRemoveStepHandler();

    private IdentityStoreRemoveStepHandler() {
        super(ModelElement.PARTITION_MANAGER.getName());
    }

    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.checkIfLastIdentityStore(context);
        super.updateModel(context, operation);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = context.getCurrentAddress();
                String configurationName = address.getElement(address.size() - 2).getValue();
                String partitionManagerName = address.getElement(address.size() - 3).getValue();
                String identityStoreName = address.getLastElement().getValue();
                context.removeService(PartitionManagerService.createIdentityStoreServiceName(partitionManagerName, configurationName, identityStoreName));
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        PartitionManagerAddHandler.INSTANCE.createPartitionManagerService(context, parentAddress.getLastElement().getValue(), parentModel, false);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return PartitionManagerService.createServiceName(parentAddress.getLastElement().getValue());
    }

    private void checkIfLastIdentityStore(OperationContext context) throws OperationFailedException {
        PathAddress parentAddress = Util.getParentAddressByKey((PathAddress)context.getCurrentAddress(), (String)ModelElement.IDENTITY_CONFIGURATION.getName());
        Resource resource = context.readResourceFromRoot(parentAddress);
        if (resource.getChildTypes().size() == 1) {
            throw PicketLinkLogger.ROOT_LOGGER.idmNoIdentityStoreProvided(parentAddress.getLastElement().getValue());
        }
    }
}

