/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BackupForResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupsResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSchema;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.XMLAttribute;
import org.jboss.as.clustering.infinispan.subsystem.XMLElement;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InfinispanSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(InfinispanSchema.CURRENT.getNamespaceUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined() && model.hasDefined(CacheContainerResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property entry : model.get(CacheContainerResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                ModelNode cache;
                String containerName = entry.getName();
                ModelNode container = entry.getValue();
                writer.writeStartElement(XMLElement.CACHE_CONTAINER.getLocalName());
                writer.writeAttribute(XMLAttribute.NAME.getLocalName(), containerName);
                InfinispanSubsystemXMLWriter.writeAttributes(writer, container, EnumSet.allOf(CacheContainerResourceDefinition.Attribute.class));
                InfinispanSubsystemXMLWriter.writeAttributes(writer, container, EnumSet.allOf(CacheContainerResourceDefinition.ExecutorAttribute.class));
                if (container.hasDefined(JGroupsTransportResourceDefinition.PATH.getKeyValuePair())) {
                    writer.writeStartElement(XMLElement.TRANSPORT.getLocalName());
                    ModelNode transport = container.get(JGroupsTransportResourceDefinition.PATH.getKeyValuePair());
                    InfinispanSubsystemXMLWriter.writeAttributes(writer, transport, EnumSet.allOf(JGroupsTransportResourceDefinition.Attribute.class));
                    InfinispanSubsystemXMLWriter.writeAttributes(writer, transport, EnumSet.allOf(JGroupsTransportResourceDefinition.ExecutorAttribute.class));
                    writer.writeEndElement();
                }
                if (container.hasDefined(ThreadPoolResourceDefinition.WILDCARD_PATH.getKey())) {
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.ASYNC_OPERATIONS_THREAD_POOL, ThreadPoolResourceDefinition.ASYNC_OPERATIONS, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.LISTENER_THREAD_POOL, ThreadPoolResourceDefinition.LISTENER, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.PERSISTENCE_THREAD_POOL, ThreadPoolResourceDefinition.PERSISTENCE, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.REMOTE_COMMAND_THREAD_POOL, ThreadPoolResourceDefinition.REMOTE_COMMAND, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.STATE_TRANSFER_THREAD_POOL, ThreadPoolResourceDefinition.STATE_TRANSFER, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(XMLElement.TRANSPORT_THREAD_POOL, ThreadPoolResourceDefinition.TRANSPORT, writer, container);
                    InfinispanSubsystemXMLWriter.writeScheduledThreadPoolElements(XMLElement.EXPIRATION_THREAD_POOL, ScheduledThreadPoolResourceDefinition.EXPIRATION, writer, container);
                }
                if (container.hasDefined(LocalCacheResourceDefinition.WILDCARD_PATH.getKey())) {
                    for (Property property : container.get(LocalCacheResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(XMLElement.LOCAL_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined(InvalidationCacheResourceDefinition.WILDCARD_PATH.getKey())) {
                    for (Property property : container.get(InvalidationCacheResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(XMLElement.INVALIDATION_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined(ReplicatedCacheResourceDefinition.WILDCARD_PATH.getKey())) {
                    for (Property property : container.get(ReplicatedCacheResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(XMLElement.REPLICATED_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined(DistributedCacheResourceDefinition.WILDCARD_PATH.getKey())) {
                    for (Property property : container.get(DistributedCacheResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(XMLElement.DISTRIBUTED_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeAttributes(writer, cache, EnumSet.allOf(DistributedCacheResourceDefinition.Attribute.class));
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeCacheAttributes(XMLExtendedStreamWriter writer, String name, ModelNode cache) throws XMLStreamException {
        writer.writeAttribute(XMLAttribute.NAME.getLocalName(), name);
        InfinispanSubsystemXMLWriter.writeAttributes(writer, cache, EnumSet.allOf(CacheResourceDefinition.Attribute.class));
    }

    private static void writeClusteredCacheAttributes(XMLExtendedStreamWriter writer, String name, ModelNode cache) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeCacheAttributes(writer, name, cache);
        InfinispanSubsystemXMLWriter.writeAttributes(writer, cache, ClusteredCacheResourceDefinition.Attribute.class);
    }

    private static void writeCacheElements(XMLExtendedStreamWriter writer, ModelNode cache) throws XMLStreamException {
        ModelNode backupFor;
        ModelNode backups;
        ModelNode stateTransfer;
        Object attributes;
        ModelNode partitionHandling;
        ModelNode store;
        ModelNode expiration;
        ModelNode eviction;
        ModelNode transaction;
        EnumSet<Enum> attributes2;
        ModelNode locking;
        if (cache.hasDefined(LockingResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(locking = cache.get(LockingResourceDefinition.PATH.getKeyValuePair()), attributes2 = EnumSet.allOf(LockingResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.LOCKING.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, locking, attributes2);
            writer.writeEndElement();
        }
        if (cache.hasDefined(TransactionResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(transaction = cache.get(TransactionResourceDefinition.PATH.getKeyValuePair()), attributes2 = EnumSet.allOf(TransactionResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.TRANSACTION.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, transaction, attributes2);
            writer.writeEndElement();
        }
        if (cache.hasDefined(EvictionResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(eviction = cache.get(EvictionResourceDefinition.PATH.getKeyValuePair()), attributes2 = EnumSet.allOf(EvictionResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.EVICTION.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, eviction, attributes2);
            writer.writeEndElement();
        }
        if (cache.hasDefined(ExpirationResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(expiration = cache.get(ExpirationResourceDefinition.PATH.getKeyValuePair()), attributes2 = EnumSet.allOf(ExpirationResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.EXPIRATION.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, expiration, attributes2);
            writer.writeEndElement();
        }
        EnumSet<StoreResourceDefinition.Attribute> storeAttributes = EnumSet.complementOf(EnumSet.of(StoreResourceDefinition.Attribute.PROPERTIES));
        if (cache.hasDefined(CustomStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(CustomStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, CustomStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, JDBCStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(FileStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(FileStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.FILE_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, FileStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(BinaryKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(BinaryKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.BINARY_KEYED_JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, JDBCStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, XMLElement.BINARY_KEYED_TABLE, store, BinaryTableResourceDefinition.PATH, BinaryTableResourceDefinition.Attribute.PREFIX);
            writer.writeEndElement();
        }
        if (cache.hasDefined(StringKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(StringKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.STRING_KEYED_JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, JDBCStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, XMLElement.STRING_KEYED_TABLE, store, StringTableResourceDefinition.PATH, StringTableResourceDefinition.Attribute.PREFIX);
            writer.writeEndElement();
        }
        if (cache.hasDefined(MixedKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(MixedKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.MIXED_KEYED_JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, JDBCStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, XMLElement.BINARY_KEYED_TABLE, store, BinaryTableResourceDefinition.PATH, BinaryTableResourceDefinition.Attribute.PREFIX);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, XMLElement.STRING_KEYED_TABLE, store, StringTableResourceDefinition.PATH, StringTableResourceDefinition.Attribute.PREFIX);
            writer.writeEndElement();
        }
        if (cache.hasDefined(RemoteStoreResourceDefinition.PATH.getKeyValuePair())) {
            store = cache.get(RemoteStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(XMLElement.REMOTE_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, RemoteStoreResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttributes(writer, store, storeAttributes);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(PartitionHandlingResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(partitionHandling = cache.get(PartitionHandlingResourceDefinition.PATH.getKeyValuePair()), attributes = EnumSet.allOf(PartitionHandlingResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.PARTITION_HANDLING.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, partitionHandling, attributes);
            writer.writeEndElement();
        }
        if (cache.hasDefined(StateTransferResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(stateTransfer = cache.get(StateTransferResourceDefinition.PATH.getKeyValuePair()), attributes = EnumSet.allOf(StateTransferResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.STATE_TRANSFER.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, stateTransfer, attributes);
            writer.writeEndElement();
        }
        if (cache.hasDefined(BackupsResourceDefinition.PATH.getKeyValuePair()) && (backups = cache.get(BackupsResourceDefinition.PATH.getKeyValuePair())).hasDefined(BackupResourceDefinition.WILDCARD_PATH.getKey())) {
            writer.writeStartElement(XMLElement.BACKUPS.getLocalName());
            attributes = backups.get(BackupResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList().iterator();
            while (attributes.hasNext()) {
                Property property = (Property)attributes.next();
                writer.writeStartElement(XMLElement.BACKUP.getLocalName());
                writer.writeAttribute(XMLAttribute.SITE.getLocalName(), property.getName());
                ModelNode backup = property.getValue();
                InfinispanSubsystemXMLWriter.writeAttributes(writer, backup, EnumSet.allOf(BackupResourceDefinition.Attribute.class));
                EnumSet<BackupResourceDefinition.TakeOfflineAttribute> takeOfflineAttributes = EnumSet.allOf(BackupResourceDefinition.TakeOfflineAttribute.class);
                if (InfinispanSubsystemXMLWriter.hasDefined(backup, takeOfflineAttributes)) {
                    writer.writeStartElement(XMLElement.TAKE_OFFLINE.getLocalName());
                    InfinispanSubsystemXMLWriter.writeAttributes(writer, backup, takeOfflineAttributes);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (cache.hasDefined(BackupForResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(backupFor = cache.get(BackupForResourceDefinition.PATH.getKeyValuePair()), attributes = EnumSet.allOf(BackupForResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.BACKUP_FOR.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, backupFor, (Iterable<? extends Attribute>)attributes);
            writer.writeEndElement();
        }
    }

    private static void writeJDBCStoreTable(XMLExtendedStreamWriter writer, XMLElement element, ModelNode store, PathElement path, Attribute prefixAttribute) throws XMLStreamException {
        if (store.hasDefined(path.getKeyValuePair())) {
            ModelNode table = store.get(path.getKeyValuePair());
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, table, TableResourceDefinition.Attribute.class);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, table, prefixAttribute);
            for (TableResourceDefinition.ColumnAttribute attribute : TableResourceDefinition.ColumnAttribute.values()) {
                if (!table.hasDefined(attribute.getDefinition().getName())) continue;
                ModelNode column = table.get(attribute.getDefinition().getName());
                writer.writeStartElement(attribute.getDefinition().getXmlName());
                InfinispanSubsystemXMLWriter.writeAttribute(writer, column, attribute.getColumnName());
                InfinispanSubsystemXMLWriter.writeAttribute(writer, column, attribute.getColumnType());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private static void writeStoreElements(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        EnumSet<StoreWriteBehindResourceDefinition.Attribute> attributes;
        ModelNode writeBehind;
        if (store.hasDefined(StoreWriteBehindResourceDefinition.PATH.getKeyValuePair()) && InfinispanSubsystemXMLWriter.hasDefined(writeBehind = store.get(StoreWriteBehindResourceDefinition.PATH.getKeyValuePair()), attributes = EnumSet.allOf(StoreWriteBehindResourceDefinition.Attribute.class))) {
            writer.writeStartElement(XMLElement.WRITE_BEHIND.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, writeBehind, attributes);
            writer.writeEndElement();
        }
        InfinispanSubsystemXMLWriter.writeElement(writer, store, StoreResourceDefinition.Attribute.PROPERTIES);
    }

    private static boolean hasDefined(ModelNode model, Iterable<? extends Attribute> attributes) {
        for (Attribute attribute : attributes) {
            if (!model.hasDefined(((AttributeDefinition)attribute.getDefinition()).getName())) continue;
            return true;
        }
        return false;
    }

    private static <A extends Enum<A>> void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Class<A> attributeClass) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeAttributes(writer, model, EnumSet.allOf(attributeClass));
    }

    private static void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Iterable<? extends Attribute> attributes) throws XMLStreamException {
        for (Attribute attribute : attributes) {
            InfinispanSubsystemXMLWriter.writeAttribute(writer, model, attribute);
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getAttributeMarshaller().marshallAsAttribute((AttributeDefinition)attribute.getDefinition(), model, true, (XMLStreamWriter)writer);
    }

    private static void writeElement(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getAttributeMarshaller().marshallAsElement((AttributeDefinition)attribute.getDefinition(), model, true, (XMLStreamWriter)writer);
    }

    private static void writeThreadPoolElements(XMLElement element, ThreadPoolResourceDefinition pool, XMLExtendedStreamWriter writer, ModelNode container) throws XMLStreamException {
        ModelNode threadPool;
        if (container.get(pool.getPathElement().getKey()).hasDefined(pool.getPathElement().getValue()) && InfinispanSubsystemXMLWriter.hasDefined(threadPool = container.get(pool.getPathElement().getKeyValuePair()), pool.getAttributes())) {
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, threadPool, pool.getAttributes());
            writer.writeEndElement();
        }
    }

    private static void writeScheduledThreadPoolElements(XMLElement element, ScheduledThreadPoolResourceDefinition pool, XMLExtendedStreamWriter writer, ModelNode container) throws XMLStreamException {
        ModelNode threadPool;
        if (container.get(pool.getPathElement().getKey()).hasDefined(pool.getPathElement().getValue()) && InfinispanSubsystemXMLWriter.hasDefined(threadPool = container.get(pool.getPathElement().getKeyValuePair()), pool.getAttributes())) {
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, threadPool, pool.getAttributes());
            writer.writeEndElement();
        }
    }
}

