/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobParser;
import org.jberet.spi.JobXmlResolver;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WildFlyJobXmlResolver
implements JobXmlResolver {
    public static final AttachmentKey<WildFlyJobXmlResolver> JOB_XML_RESOLVER = AttachmentKey.create(WildFlyJobXmlResolver.class);
    private final Set<JobXmlResolver> jobXmlResolvers;
    private final Map<String, String> resolvedJobs;
    private final Map<String, VirtualFile> jobXmlFiles;
    private final ClassLoader classLoader;

    private WildFlyJobXmlResolver() {
        this.classLoader = null;
        this.resolvedJobs = Collections.emptyMap();
        this.jobXmlResolvers = Collections.emptySet();
        this.jobXmlFiles = Collections.emptyMap();
    }

    private WildFlyJobXmlResolver(ClassLoader classLoader, Map<String, VirtualFile> jobXmlFiles) {
        this.classLoader = classLoader;
        this.resolvedJobs = new LinkedHashMap<String, String>();
        this.jobXmlResolvers = new LinkedHashSet<JobXmlResolver>();
        this.jobXmlFiles = jobXmlFiles;
    }

    public static WildFlyJobXmlResolver of(ClassLoader classLoader, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        WildFlyJobXmlResolver jobXmlResolver;
        VirtualFile root = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        VirtualFile jobsDir = DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) ? root.getChild("WEB-INF/classes/META-INF/batch-jobs") : root.getChild("META-INF/batch-jobs");
        if (jobsDir != null && jobsDir.exists()) {
            try {
                Map<String, VirtualFile> xmlFiles = jobsDir.getChildren((VirtualFileFilter)JobXmlFilter.INSTANCE).stream().collect(Collectors.toMap(VirtualFile::getName, f -> f));
                jobXmlResolver = new WildFlyJobXmlResolver(classLoader, xmlFiles);
                jobXmlResolver.init();
            }
            catch (IOException e) {
                throw BatchLogger.LOGGER.errorProcessingBatchJobsDir(e);
            }
        } else {
            jobXmlResolver = new WildFlyJobXmlResolver();
        }
        deploymentUnit.putAttachment(JOB_XML_RESOLVER, (Object)jobXmlResolver);
        return jobXmlResolver;
    }

    public InputStream resolveJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        if (this.jobXmlFiles.isEmpty() && this.jobXmlResolvers.isEmpty()) {
            return null;
        }
        for (JobXmlResolver resolver : this.jobXmlResolvers) {
            InputStream in = resolver.resolveJobXml(jobXml, classLoader);
            if (in == null) continue;
            return in;
        }
        VirtualFile file = this.jobXmlFiles.get(jobXml);
        if (file == null) {
            return null;
        }
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(() -> {
                try {
                    return file.openStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return file.openStream();
    }

    public Collection<String> getJobXmlNames(ClassLoader classLoader) {
        return new ArrayList<String>(this.resolvedJobs.keySet());
    }

    public String resolveJobName(String jobXml, ClassLoader classLoader) {
        return this.resolvedJobs.get(jobXml);
    }

    private void init() {
        for (JobXmlResolver jobXmlResolver : ServiceLoader.load(JobXmlResolver.class, this.classLoader)) {
            this.jobXmlResolvers.add(jobXmlResolver);
            for (String jobXml : jobXmlResolver.getJobXmlNames(this.classLoader)) {
                this.resolvedJobs.put(jobXml, jobXmlResolver.resolveJobName(jobXml, this.classLoader));
            }
        }
        for (Map.Entry entry : this.jobXmlFiles.entrySet()) {
            try {
                Job job = JobParser.parseJob((InputStream)((VirtualFile)entry.getValue()).openStream(), (ClassLoader)this.classLoader, (XMLResolver)new XMLResolver(){

                    @Override
                    public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                        try {
                            return WildFlyJobXmlResolver.this.jobXmlFiles.containsKey(systemID) ? ((VirtualFile)WildFlyJobXmlResolver.this.jobXmlFiles.get(systemID)).openStream() : null;
                        }
                        catch (IOException e) {
                            throw new XMLStreamException(e);
                        }
                    }
                });
                this.resolvedJobs.put((String)entry.getKey(), job.getId());
            }
            catch (IOException | XMLStreamException e) {
                BatchLogger.LOGGER.invalidJobXmlFile((String)entry.getKey());
            }
        }
    }

    private static class JobXmlFilter
    implements VirtualFileFilter {
        static final JobXmlFilter INSTANCE = new JobXmlFilter();

        private JobXmlFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return file.isFile() && file.getName().endsWith(".xml");
        }
    }
}

