/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SaslOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 65536;
    private final OutputStream outStream;
    private final SaslClient saslClient;
    private final int bufferSize;
    private final ByteArrayOutputStream buffer;

    public SaslOutputStream(OutputStream outStream, SaslClient saslClient) {
        this.saslClient = saslClient;
        this.outStream = new BufferedOutputStream(outStream, 65536);
        String maxSendBuf = (String)saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        this.bufferSize = maxSendBuf != null ? Integer.parseInt(maxSendBuf) : 65536;
        this.buffer = new ByteArrayOutputStream(this.bufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkCapacity(1);
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkCapacity(len);
        this.buffer.write(b, off, len);
    }

    private void writeInt(int i) throws IOException {
        this.outStream.write(i >>> 24 & 0xFF);
        this.outStream.write(i >>> 16 & 0xFF);
        this.outStream.write(i >>> 8 & 0xFF);
        this.outStream.write(i >>> 0 & 0xFF);
    }

    private void checkCapacity(int capacity) throws IOException {
        if (this.buffer.size() + capacity >= this.bufferSize) {
            this.flush();
        }
    }

    private void wrapAndWrite() throws IOException {
        try {
            byte[] saslToken = this.saslClient.wrap(this.buffer.toByteArray(), 0, this.buffer.size());
            this.writeInt(saslToken.length);
            this.outStream.write(saslToken);
            this.buffer.reset();
        }
        catch (SaslException se) {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
            throw se;
        }
    }

    @Override
    public void flush() throws IOException {
        this.wrapAndWrite();
        this.outStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.saslClient.dispose();
        this.outStream.close();
    }
}

