/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StructGen
implements com.sun.tools.corba.se.idl.StructGen,
JavaGenerator {
    protected Hashtable symbolTable = null;
    protected StructEntry s = null;
    protected PrintWriter stream = null;
    protected boolean thisIsReallyAnException = false;
    private boolean[] memberIsPrimitive;
    private boolean[] memberIsInterface;
    private boolean[] memberIsTypedef;

    public StructGen() {
    }

    protected StructGen(boolean exception) {
        this.thisIsReallyAnException = exception;
    }

    @Override
    public void generate(Hashtable symbolTable, StructEntry s, PrintWriter str) {
        this.symbolTable = symbolTable;
        this.s = s;
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.generateHelper();
        this.generateHolder();
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
        this.generateContainedTypes();
    }

    protected void init() {
    }

    protected void openStream() {
        this.stream = Util.stream(this.s, ".java");
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.s);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.s);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.s);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.s.comment() != null) {
            this.s.comment().generate("", this.stream);
        }
        this.stream.print("public final class " + this.s.name());
        if (this.thisIsReallyAnException) {
            this.stream.print(" extends org.omg.CORBA.UserException");
        } else {
            this.stream.print(" implements org.omg.CORBA.portable.IDLEntity");
        }
        this.stream.println();
        this.stream.println("{");
    }

    protected void writeBody() {
        this.writeMembers();
        this.writeCtors();
    }

    protected void writeClosing() {
        this.stream.println("} // class " + this.s.name());
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void generateContainedTypes() {
        Enumeration e = this.s.contained().elements();
        while (e.hasMoreElements()) {
            SymtabEntry entry = (SymtabEntry)e.nextElement();
            if (entry instanceof SequenceEntry) continue;
            entry.generate(this.symbolTable, this.stream);
        }
    }

    protected void writeMembers() {
        int size = this.s.members().size();
        this.memberIsPrimitive = new boolean[size];
        this.memberIsInterface = new boolean[size];
        this.memberIsTypedef = new boolean[size];
        for (int i = 0; i < this.s.members().size(); ++i) {
            SymtabEntry member = (SymtabEntry)this.s.members().elementAt(i);
            this.memberIsPrimitive[i] = member.type() instanceof PrimitiveEntry;
            this.memberIsInterface[i] = member.type() instanceof InterfaceEntry;
            this.memberIsTypedef[i] = member.type() instanceof TypedefEntry;
            Util.fillInfo(member);
            if (member.comment() != null) {
                member.comment().generate("  ", this.stream);
            }
            Util.writeInitializer("  public ", member.name(), "", member, this.stream);
        }
    }

    protected void writeCtors() {
        this.stream.println();
        this.stream.println("  public " + this.s.name() + " ()");
        this.stream.println("  {");
        if (this.thisIsReallyAnException) {
            this.stream.println("    super(" + this.s.name() + "Helper.id());");
        }
        this.stream.println("  } // ctor");
        this.writeInitializationCtor(true);
        if (this.thisIsReallyAnException) {
            this.writeInitializationCtor(false);
        }
    }

    private void writeInitializationCtor(boolean init) {
        if (!init || this.s.members().size() > 0) {
            SymtabEntry member;
            int i;
            this.stream.println();
            this.stream.print("  public " + this.s.name() + " (");
            boolean firstTime = true;
            if (!init) {
                this.stream.print("String $reason");
                firstTime = false;
            }
            for (i = 0; i < this.s.members().size(); ++i) {
                member = (SymtabEntry)this.s.members().elementAt(i);
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.stream.print(", ");
                }
                this.stream.print(Util.javaName(member) + " _" + member.name());
            }
            this.stream.println(")");
            this.stream.println("  {");
            if (this.thisIsReallyAnException) {
                if (init) {
                    this.stream.println("    super(" + this.s.name() + "Helper.id());");
                } else {
                    this.stream.println("    super(" + this.s.name() + "Helper.id() + \"  \" + $reason);");
                }
            }
            for (i = 0; i < this.s.members().size(); ++i) {
                member = (SymtabEntry)this.s.members().elementAt(i);
                this.stream.println("    " + member.name() + " = _" + member.name() + ";");
            }
            this.stream.println("  } // ctor");
        }
        this.stream.println();
    }

    @Override
    public int helperType(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        TCOffsets innerOffsets = new TCOffsets();
        innerOffsets.set(entry);
        int offsetForStruct = innerOffsets.currentOffset();
        StructEntry s = (StructEntry)entry;
        String membersName = "_members" + index++;
        stream.println(indent + "org.omg.CORBA.StructMember[] " + membersName + " = new org.omg.CORBA.StructMember [" + s.members().size() + "];");
        String tcOfMembers = "_tcOf" + membersName;
        stream.println(indent + "org.omg.CORBA.TypeCode " + tcOfMembers + " = null;");
        for (int i = 0; i < s.members().size(); ++i) {
            TypedefEntry member = (TypedefEntry)s.members().elementAt(i);
            String memberName = member.name();
            index = ((JavaGenerator)((Object)member.generator())).type(index, indent, innerOffsets, tcOfMembers, member, stream);
            stream.println(indent + membersName + '[' + i + "] = new org.omg.CORBA.StructMember (");
            stream.println(indent + "  \"" + Util.stripLeadingUnderscores(memberName) + "\",");
            stream.println(indent + "  " + tcOfMembers + ',');
            stream.println(indent + "  null);");
            int offsetSoFar = innerOffsets.currentOffset();
            innerOffsets = new TCOffsets();
            innerOffsets.set(entry);
            innerOffsets.bumpCurrentOffset(offsetSoFar - offsetForStruct);
        }
        tcoffsets.bumpCurrentOffset(innerOffsets.currentOffset());
        stream.println(indent + name + " = org.omg.CORBA.ORB.init ().create_" + (this.thisIsReallyAnException ? "exception" : "struct") + "_tc (" + Util.helperName(s, true) + ".id (), \"" + Util.stripLeadingUnderscores(entry.name()) + "\", " + membersName + ");");
        return index;
    }

    @Override
    public int type(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        stream.println(indent + name + " = " + Util.helperName(entry, true) + ".type ();");
        return index;
    }

    @Override
    public void helperRead(String entryName, SymtabEntry entry, PrintWriter stream) {
        stream.println("    " + entryName + " value = new " + entryName + " ();");
        this.read(0, "    ", "value", entry, stream);
        stream.println("    return value;");
    }

    @Override
    public int read(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        if (this.thisIsReallyAnException) {
            stream.println(indent + "// read and discard the repository ID");
            stream.println(indent + "istream.read_string ();");
        }
        Enumeration e = ((StructEntry)entry).members().elements();
        while (e.hasMoreElements()) {
            TypedefEntry member = (TypedefEntry)e.nextElement();
            SymtabEntry mType = member.type();
            if (!member.arrayInfo().isEmpty() || mType instanceof SequenceEntry || mType instanceof PrimitiveEntry || mType instanceof StringEntry || mType instanceof TypedefEntry) {
                index = ((JavaGenerator)((Object)member.generator())).read(index, indent, name + '.' + member.name(), member, stream);
                continue;
            }
            if (mType instanceof ValueBoxEntry) {
                Vector st = ((ValueBoxEntry)mType).state();
                TypedefEntry vbMember = ((InterfaceState)st.elementAt((int)0)).entry;
                SymtabEntry vbType = vbMember.type();
                String jName = null;
                String jHelper = null;
                if (vbType instanceof SequenceEntry || vbType instanceof StringEntry || !vbMember.arrayInfo().isEmpty()) {
                    jName = Util.javaName(vbType);
                    jHelper = Util.helperName(mType, true);
                } else {
                    jName = Util.javaName(mType);
                    jHelper = Util.helperName(mType, true);
                }
                if (Util.corbaLevel(2.4f, 99.0f)) {
                    stream.println(indent + name + '.' + member.name() + " = (" + jName + ") " + jHelper + ".read (istream);");
                    continue;
                }
                stream.println(indent + name + '.' + member.name() + " = (" + jName + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + jHelper + ".get_instance ());");
                continue;
            }
            if (mType instanceof ValueEntry && !Util.corbaLevel(2.4f, 99.0f)) {
                stream.println(indent + name + '.' + member.name() + " = (" + Util.javaName(mType) + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(mType, false) + ".get_instance ());");
                continue;
            }
            stream.println(indent + name + '.' + member.name() + " = " + Util.helperName(member.type(), true) + ".read (istream);");
        }
        return index;
    }

    @Override
    public void helperWrite(SymtabEntry entry, PrintWriter stream) {
        this.write(0, "    ", "value", entry, stream);
    }

    @Override
    public int write(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        if (this.thisIsReallyAnException) {
            stream.println(indent + "// write the repository ID");
            stream.println(indent + "ostream.write_string (id ());");
        }
        Vector members = ((StructEntry)entry).members();
        for (int i = 0; i < members.size(); ++i) {
            TypedefEntry member = (TypedefEntry)members.elementAt(i);
            SymtabEntry mType = member.type();
            if (!member.arrayInfo().isEmpty() || mType instanceof SequenceEntry || mType instanceof TypedefEntry || mType instanceof PrimitiveEntry || mType instanceof StringEntry) {
                index = ((JavaGenerator)((Object)member.generator())).write(index, "    ", name + '.' + member.name(), member, stream);
                continue;
            }
            if ((mType instanceof ValueEntry || mType instanceof ValueBoxEntry) && !Util.corbaLevel(2.4f, 99.0f)) {
                stream.println(indent + "((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_value ((java.io.Serializable) " + name + '.' + member.name() + ", " + Util.helperName(member.type(), true) + ".get_instance ());");
                continue;
            }
            stream.println(indent + Util.helperName(member.type(), true) + ".write (ostream, " + name + '.' + member.name() + ");");
        }
        return index;
    }
}

