/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.as.controller.audit.AbstractFileAuditLogHandler;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.services.path.PathManagerService;

public class FileAuditLogHandler
extends AbstractFileAuditLogHandler {
    private static final SimpleDateFormat OLD_FILE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HHmmss");

    public FileAuditLogHandler(String name, String formatterName, int maxFailureCount, PathManagerService pathManager, String path, String relativeTo) {
        super(name, formatterName, maxFailureCount, pathManager, path, relativeTo);
    }

    @Override
    protected void initializeAtStartup(File file) {
        if (file.exists()) {
            File backup = new File(file.getParentFile(), file.getName() + OLD_FILE_FORMATTER.format(new Date()));
            try {
                this.rename(file, backup);
            }
            catch (IOException e) {
                throw ControllerLogger.ROOT_LOGGER.couldNotBackUp(e, file.getAbsolutePath(), backup.getAbsolutePath());
            }
        }
    }

    @Override
    protected void rotateLogFile(File file) {
    }

    @Override
    boolean isDifferent(AuditLogHandler other) {
        if (!(other instanceof FileAuditLogHandler)) {
            return true;
        }
        return super.isDifferent(other);
    }
}

