/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;
import org.jboss.resource.adapter.jms.JmsCred;
import org.jboss.resource.adapter.jms.JmsLocalTransaction;
import org.jboss.resource.adapter.jms.JmsManagedConnectionFactory;
import org.jboss.resource.adapter.jms.JmsMetaData;
import org.jboss.resource.adapter.jms.JmsSession;
import org.jboss.resource.adapter.jms.JmsXAResource;
import org.jboss.resource.adapter.jms.ReentrantLock;
import org.jboss.resource.adapter.jms.SecurityActions;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;

public class JmsManagedConnection
implements ManagedConnection,
ExceptionListener {
    private static final Logger log = Logger.getLogger(JmsManagedConnection.class);
    private JmsManagedConnectionFactory mcf;
    private JmsConnectionRequestInfo info;
    private String user;
    private String pwd;
    private boolean isDestroyed;
    private ReentrantLock lock = new ReentrantLock(true);
    private Connection con;
    private Session session;
    private XASession xaSession;
    private XAResource xaResource;
    private boolean xaTransacted;
    private Set handles = Collections.synchronizedSet(new HashSet());
    private Vector listeners = new Vector();

    public JmsManagedConnection(JmsManagedConnectionFactory mcf, ConnectionRequestInfo info, String user, String pwd) throws ResourceException {
        this.mcf = mcf;
        this.info = (JmsConnectionRequestInfo)info;
        this.user = user;
        this.pwd = pwd;
        try {
            this.setup();
        }
        catch (Throwable t) {
            try {
                this.destroy();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new ResourceException(t);
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        JmsCred cred = JmsCred.getJmsCred(this.mcf, subject, info);
        if (this.user != null && !this.user.equals(cred.name)) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (cred.name != null && this.user == null) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        this.user = cred.name;
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        JmsSession handle = new JmsSession(this, (JmsConnectionRequestInfo)info);
        this.handles.add(handle);
        return handle;
    }

    private void destroyHandles() throws ResourceException {
        try {
            if (this.con != null) {
                this.con.stop();
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Ignored error stopping connection", t);
        }
        Iterator iter = this.handles.iterator();
        while (iter.hasNext()) {
            ((JmsSession)iter.next()).destroy();
        }
        this.handles.clear();
    }

    public void destroy() throws ResourceException {
        if (this.isDestroyed || this.con == null) {
            return;
        }
        this.isDestroyed = true;
        try {
            this.con.setExceptionListener(null);
        }
        catch (JMSException e) {
            log.debug((Object)("Error unsetting the exception listener " + this), (Throwable)e);
        }
        this.destroyHandles();
        try {
            try {
                if (this.session != null) {
                    this.session.close();
                }
                if (this.xaTransacted && this.xaSession != null) {
                    this.xaSession.close();
                }
            }
            catch (JMSException e) {
                log.debug((Object)("Error closing session " + this), (Throwable)e);
            }
            this.con.close();
        }
        catch (Throwable e) {
            throw new ResourceException("Could not properly close the session and connection", e);
        }
    }

    public void cleanup() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyed");
        }
        this.destroyHandles();
        boolean isActive = false;
        if (this.lock.hasQueuedThreads()) {
            Collection<Thread> threads = this.lock.getQueuedThreads();
            for (Thread thread : threads) {
                Throwable t = new Throwable("Thread waiting for lock during cleanup");
                t.setStackTrace(thread.getStackTrace());
                log.warn((Object)t.getMessage(), t);
            }
            isActive = true;
        }
        if (this.lock.isLocked()) {
            Throwable t = new Throwable("Lock owned during cleanup");
            t.setStackTrace(this.lock.getOwner().getStackTrace());
            log.warn((Object)t.getMessage(), t);
            isActive = true;
        }
        if (isActive) {
            throw new ResourceException("Still active locks for " + this);
        }
        try {
            if (this.con.getClientID() != null) {
                throw new ResourceException("Cleaning up " + this + " bound to clientID = " + this.con.getClientID());
            }
        }
        catch (JMSException e) {
            throw new ResourceException("Cleaning up " + this);
        }
    }

    public void associateConnection(Object obj) throws ResourceException {
        if (this.isDestroyed || !(obj instanceof JmsSession)) {
            throw new IllegalStateException("ManagedConnection in an illegal state");
        }
        JmsSession h = (JmsSession)obj;
        h.setManagedConnection(this);
        this.handles.add(h);
    }

    protected void lock() {
        this.lock.lock();
    }

    protected void tryLock() throws JMSException {
        int tryLock = this.mcf.getUseTryLock();
        if (tryLock <= 0) {
            this.lock();
            return;
        }
        try {
            if (!this.lock.tryLock(tryLock, TimeUnit.SECONDS)) {
                throw new ResourceAllocationException("Unable to obtain lock in " + tryLock + " seconds: " + this);
            }
        }
        catch (InterruptedException e) {
            throw new ResourceAllocationException("Interrupted attempting lock: " + this);
        }
    }

    protected void unlock() {
        if (this.lock.isLocked()) {
            this.lock.unlock();
        } else {
            log.warn((Object)"Owner is null");
            Throwable t = new Throwable("Thread trying to unlock");
            t.setStackTrace(Thread.currentThread().getStackTrace());
            log.warn((Object)t.getMessage(), t);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener l) {
        this.listeners.addElement(l);
        if (log.isTraceEnabled()) {
            log.trace((Object)("ConnectionEvent listener added: " + l));
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener l) {
        this.listeners.removeElement(l);
    }

    public XAResource getXAResource() throws ResourceException {
        if (!this.xaTransacted) {
            return null;
        }
        if (this.xaResource == null) {
            this.xaResource = this.xaSession.getXAResource();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("XAResource=" + this.xaResource));
        }
        this.xaResource = new JmsXAResource(this, this.xaResource);
        return this.xaResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        JmsLocalTransaction tx = new JmsLocalTransaction(this);
        if (log.isTraceEnabled()) {
            log.trace((Object)("LocalTransaction=" + tx));
        }
        return tx;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.isDestroyed) {
            throw new IllegalStateException("ManagedConnection already destroyd");
        }
        return new JmsMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public void onException(JMSException exception) {
        if (this.isDestroyed) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Ignoring error on already destroyed connection " + this), (Throwable)exception);
            }
            return;
        }
        log.warn((Object)("Handling jms exception failure: " + this), (Throwable)exception);
        if (this.lock.isLocked() && Thread.currentThread().equals(this.lock.getOwner())) {
            this.unlock();
        }
        try {
            this.con.setExceptionListener(null);
        }
        catch (JMSException e) {
            log.debug((Object)"Unable to unset exception listener", (Throwable)e);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, (Exception)((Object)exception));
        this.sendEvent(event);
    }

    protected Session getSession() {
        return this.session;
    }

    protected void sendEvent(ConnectionEvent event) {
        int type = event.getId();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Sending connection event: " + type));
        }
        ConnectionEventListener[] list = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        block7: for (int i = 0; i < list.length; ++i) {
            switch (type) {
                case 1: {
                    list[i].connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    list[i].localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    list[i].localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    list[i].localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    list[i].connectionErrorOccurred(event);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + type);
                }
            }
        }
    }

    protected void removeHandle(JmsSession handle) {
        this.handles.remove(handle);
    }

    protected ConnectionRequestInfo getInfo() {
        return this.info;
    }

    protected JmsManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    void start() throws JMSException {
        this.con.start();
    }

    void stop() throws JMSException {
        this.con.stop();
    }

    protected String getUserName() {
        return this.user;
    }

    private void setup() throws ResourceException {
        boolean trace = log.isTraceEnabled();
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            SecurityActions.setThreadContextClassLoader(JmsManagedConnection.class.getClassLoader());
            Context context = JmsActivation.convertStringToContext(this.mcf.getJndiParameters());
            boolean transacted = this.info.isTransacted();
            int ack = transacted ? 0 : this.info.getAcknowledgeMode();
            String connectionFactory = this.mcf.getConnectionFactory();
            if (connectionFactory == null) {
                throw new IllegalStateException("No configured 'connectionFactory'.");
            }
            Object factory = context.lookup(connectionFactory);
            this.con = this.createConnection(factory, this.user, this.pwd);
            if (this.info.getClientID() != null && !this.info.getClientID().equals(this.con.getClientID())) {
                this.con.setClientID(this.info.getClientID());
            }
            this.con.setExceptionListener((ExceptionListener)this);
            if (trace) {
                log.trace((Object)("created connection: " + this.con));
            }
            if (this.con instanceof XAConnection && transacted) {
                if (this.mcf.getProperties().getType() == 1) {
                    this.xaSession = ((XAQueueConnection)this.con).createXAQueueSession();
                    this.session = ((XAQueueSession)this.xaSession).getQueueSession();
                } else if (this.mcf.getProperties().getType() == 2) {
                    this.xaSession = ((XATopicConnection)this.con).createXATopicSession();
                    this.session = ((XATopicSession)this.xaSession).getTopicSession();
                } else {
                    this.xaSession = ((XAConnection)this.con).createXASession();
                    this.session = this.xaSession.getSession();
                }
                this.xaTransacted = true;
            } else {
                this.session = this.mcf.getProperties().getType() == 1 ? ((QueueConnection)this.con).createQueueSession(transacted, ack) : (this.mcf.getProperties().getType() == 2 ? ((TopicConnection)this.con).createTopicSession(transacted, ack) : this.con.createSession(transacted, ack));
                if (trace) {
                    log.trace((Object)"Using a non-XA Connection.  It will not be able to participate in a Global UOW");
                }
            }
            log.debug((Object)("xaSession=" + this.xaSession + ", Session=" + this.session));
            log.debug((Object)("transacted=" + transacted + ", ack=" + ack));
        }
        catch (NamingException e) {
            throw new ResourceException("Unable to setup connection", (Throwable)e);
        }
        catch (JMSException e) {
            throw new ResourceException("Unable to setup connection", (Throwable)e);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    public Connection createConnection(Object factory, String username, String password) throws JMSException {
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        log.debug((Object)("using connection factory: " + factory));
        log.debug((Object)("using username/password: " + String.valueOf(username) + "/-- not shown --"));
        Object connection = null;
        if (factory instanceof XAConnectionFactory) {
            XAConnectionFactory qFactory = (XAConnectionFactory)factory;
            connection = username != null ? (this.mcf.getProperties().getType() == 1 ? ((XAQueueConnectionFactory)qFactory).createXAQueueConnection(username, password) : (this.mcf.getProperties().getType() == 2 ? ((XATopicConnectionFactory)qFactory).createXATopicConnection(username, password) : qFactory.createXAConnection(username, password))) : (this.mcf.getProperties().getType() == 1 ? ((XAQueueConnectionFactory)qFactory).createXAQueueConnection() : (this.mcf.getProperties().getType() == 2 ? ((XATopicConnectionFactory)qFactory).createXATopicConnection() : qFactory.createXAConnection()));
            log.debug((Object)("created XAConnection: " + connection));
        } else if (factory instanceof ConnectionFactory) {
            ConnectionFactory qFactory = (ConnectionFactory)factory;
            connection = username != null ? (this.mcf.getProperties().getType() == 1 ? ((QueueConnectionFactory)qFactory).createQueueConnection(username, password) : (this.mcf.getProperties().getType() == 2 ? ((TopicConnectionFactory)qFactory).createTopicConnection(username, password) : qFactory.createConnection(username, password))) : (this.mcf.getProperties().getType() == 1 ? ((QueueConnectionFactory)qFactory).createQueueConnection() : (this.mcf.getProperties().getType() == 2 ? ((TopicConnectionFactory)qFactory).createTopicConnection() : qFactory.createConnection()));
            log.debug((Object)("created " + this.mcf.getProperties().getSessionDefaultType() + " connection: " + connection));
        } else {
            throw new IllegalArgumentException("factory is invalid: " + factory);
        }
        return connection;
    }
}

