/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.HttpServerFileUploadImpl;
import io.vertx.core.http.impl.ServerConnection;
import io.vertx.core.http.impl.UriParser;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public class HttpServerRequestImpl
implements HttpServerRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpServerRequestImpl.class);
    private final ServerConnection conn;
    private final HttpRequest request;
    private final HttpServerResponse response;
    private HttpVersion version;
    private HttpMethod method;
    private String uri;
    private String path;
    private String query;
    private Handler<Buffer> dataHandler;
    private Handler<Throwable> exceptionHandler;
    private MultiMap params;
    private MultiMap headers;
    private String absoluteURI;
    private NetSocket netSocket;
    private Handler<HttpServerFileUpload> uploadHandler;
    private Handler<Void> endHandler;
    private MultiMap attributes;
    private HttpPostRequestDecoder decoder;
    private boolean ended;

    HttpServerRequestImpl(ServerConnection conn, HttpRequest request, HttpServerResponse response) {
        this.conn = conn;
        this.request = request;
        this.response = response;
    }

    @Override
    public HttpVersion version() {
        if (this.version == null) {
            io.netty.handler.codec.http.HttpVersion nettyVersion = this.request.getProtocolVersion();
            if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0) {
                this.version = HttpVersion.HTTP_1_0;
            } else if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                this.version = HttpVersion.HTTP_1_1;
            } else {
                throw new IllegalStateException("Unsupported HTTP version: " + nettyVersion);
            }
        }
        return this.version;
    }

    @Override
    public HttpMethod method() {
        if (this.method == null) {
            this.method = HttpMethod.valueOf(this.request.getMethod().toString());
        }
        return this.method;
    }

    @Override
    public String uri() {
        if (this.uri == null) {
            this.uri = this.request.getUri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = UriParser.path(this.uri());
        }
        return this.path;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = UriParser.query(this.uri());
        }
        return this.query;
    }

    @Override
    public HttpServerResponse response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HeadersAdaptor(this.request.headers());
        }
        return this.headers;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public MultiMap params() {
        if (this.params == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri());
            Map<String, List<String>> prms = queryStringDecoder.parameters();
            this.params = new CaseInsensitiveHeaders();
            if (!prms.isEmpty()) {
                for (Map.Entry<String, List<String>> entry : prms.entrySet()) {
                    this.params.add(entry.getKey(), (Iterable<String>)entry.getValue());
                }
            }
        }
        return this.params;
    }

    @Override
    public String getParam(String paramName) {
        return this.params().get(paramName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> dataHandler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkEnded();
            this.dataHandler = dataHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest pause() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.conn.pause();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest resume() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.conn.resume();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkEnded();
            this.endHandler = handler;
            return this;
        }
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public String absoluteURI() {
        if (this.absoluteURI == null) {
            try {
                String host;
                URI uri = new URI(this.uri());
                String scheme = uri.getScheme();
                this.absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri.toString() : ((host = this.headers().get("Host")) != null ? (this.conn.isSSL() ? "https://" : "http://") + host + uri : this.conn.getServerOrigin() + uri);
            }
            catch (URISyntaxException e) {
                log.error("Failed to create abs uri", e);
            }
        }
        return this.absoluteURI;
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.getPeerCertificateChain();
    }

    @Override
    public HttpServerRequest bodyHandler(Handler<Buffer> bodyHandler) {
        Buffer body = Buffer.buffer();
        this.handler(body::appendBuffer);
        this.endHandler(v -> bodyHandler.handle(body));
        return this;
    }

    @Override
    public NetSocket netSocket() {
        if (this.netSocket == null) {
            this.netSocket = this.conn.createNetSocket();
        }
        return this.netSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkEnded();
            this.uploadHandler = handler;
            return this;
        }
    }

    @Override
    public MultiMap formAttributes() {
        return this.attributes();
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public ServerWebSocket upgrade() {
        return this.conn.upgrade(this, this.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkEnded();
            if (expect) {
                String contentType;
                if (this.decoder == null && (contentType = this.request.headers().get("Content-Type")) != null) {
                    io.netty.handler.codec.http.HttpMethod method = this.request.getMethod();
                    String lowerCaseContentType = contentType.toLowerCase();
                    boolean isURLEncoded = lowerCaseContentType.startsWith("application/x-www-form-urlencoded");
                    if ((lowerCaseContentType.startsWith("multipart/form-data") || isURLEncoded) && (method.equals(io.netty.handler.codec.http.HttpMethod.POST) || method.equals(io.netty.handler.codec.http.HttpMethod.PUT) || method.equals(io.netty.handler.codec.http.HttpMethod.PATCH) || method.equals(io.netty.handler.codec.http.HttpMethod.DELETE))) {
                        this.decoder = new HttpPostRequestDecoder(new DataFactory(), this.request);
                    }
                }
            } else {
                this.decoder = null;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpectMultipart() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            return this.decoder != null;
        }
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            return this.ended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleData(Buffer data) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            if (this.decoder != null) {
                try {
                    this.decoder.offer(new DefaultHttpContent(data.getByteBuf().duplicate()));
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                    this.handleException(e);
                }
            }
            if (this.dataHandler != null) {
                this.dataHandler.handle(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.ended = true;
            if (this.decoder != null) {
                try {
                    this.decoder.offer(LastHttpContent.EMPTY_LAST_CONTENT);
                    while (this.decoder.hasNext()) {
                        InterfaceHttpData data = this.decoder.next();
                        if (!(data instanceof Attribute)) continue;
                        Attribute attr = (Attribute)data;
                        try {
                            this.attributes().add(attr.getName(), attr.getValue());
                        }
                        catch (Exception e) {
                            this.handleException(e);
                        }
                    }
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                    this.handleException(e);
                }
                catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
                }
                finally {
                    this.decoder.destroy();
                }
            }
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(t);
            }
        }
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    private MultiMap attributes() {
        if (this.attributes == null) {
            this.attributes = new CaseInsensitiveHeaders();
        }
        return this.attributes;
    }

    private static String urlDecode(String str) {
        return QueryStringDecoder.decodeComponent(str, CharsetUtil.UTF_8);
    }

    private class DataFactory
    extends DefaultHttpDataFactory {
        DataFactory() {
            super(false);
        }

        @Override
        public FileUpload createFileUpload(HttpRequest httpRequest, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
            HttpServerFileUploadImpl upload = new HttpServerFileUploadImpl(HttpServerRequestImpl.this.conn.vertx(), HttpServerRequestImpl.this, name, filename, contentType, contentTransferEncoding, charset, size);
            NettyFileUpload nettyUpload = new NettyFileUpload(upload, name, filename, contentType, contentTransferEncoding, charset);
            if (HttpServerRequestImpl.this.uploadHandler != null) {
                HttpServerRequestImpl.this.uploadHandler.handle(upload);
            }
            return nettyUpload;
        }
    }

    private static final class NettyFileUpload
    implements FileUpload {
        private final HttpServerFileUploadImpl upload;
        private final String name;
        private String contentType;
        private String filename;
        private String contentTransferEncoding;
        private Charset charset;
        private boolean completed;

        private NettyFileUpload(HttpServerFileUploadImpl upload, String name, String filename, String contentType, String contentTransferEncoding, Charset charset) {
            this.upload = upload;
            this.name = name;
            this.filename = filename;
            this.contentType = contentType;
            this.contentTransferEncoding = contentTransferEncoding;
            this.charset = charset;
        }

        @Override
        public void setContent(ByteBuf channelBuffer) throws IOException {
            this.completed = true;
            this.upload.receiveData(Buffer.buffer(channelBuffer));
            this.upload.complete();
        }

        @Override
        public void addContent(ByteBuf channelBuffer, boolean last) throws IOException {
            this.upload.receiveData(Buffer.buffer(channelBuffer));
            if (last) {
                this.completed = true;
                this.upload.complete();
            }
        }

        @Override
        public void setContent(File file) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setContent(InputStream inputStream) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCompleted() {
            return this.completed;
        }

        @Override
        public long length() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] get() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuf getChunk(int i) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString(Charset charset) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        public boolean renameTo(File file) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInMemory() {
            return false;
        }

        @Override
        public File getFile() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InterfaceHttpData.HttpDataType getHttpDataType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(InterfaceHttpData o) {
            return 0;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public void setFilename(String filename) {
            this.filename = filename;
        }

        @Override
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void setContentTransferEncoding(String contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
        }

        @Override
        public String getContentTransferEncoding() {
            return this.contentTransferEncoding;
        }

        @Override
        public ByteBuf getByteBuf() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileUpload copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileUpload duplicate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileUpload retain() {
            return this;
        }

        @Override
        public FileUpload retain(int increment) {
            return this;
        }

        @Override
        public ByteBuf content() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int refCnt() {
            return 1;
        }

        @Override
        public boolean release() {
            return false;
        }

        @Override
        public boolean release(int decrement) {
            return false;
        }
    }
}

