/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogDelegate
implements LogDelegate {
    private static final String FQCN = Logger.class.getCanonicalName();
    private final org.slf4j.Logger logger;

    SLF4JLogDelegate(String name) {
        this.logger = LoggerFactory.getLogger(name);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void fatal(Object message) {
        this.log(40, message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(40, message, t);
    }

    @Override
    public void error(Object message) {
        this.log(40, message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(40, message, t);
    }

    @Override
    public void warn(Object message) {
        this.log(30, message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(30, message, t);
    }

    @Override
    public void info(Object message) {
        this.log(20, message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(20, message, t);
    }

    @Override
    public void debug(Object message) {
        this.log(10, message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(10, message, t);
    }

    @Override
    public void trace(Object message) {
        this.log(0, message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(0, message, t);
    }

    private void log(int level, Object message) {
        this.log(level, message, null);
    }

    private void log(int level, Object message, Throwable t) {
        String msg;
        String string = msg = message == null ? "NULL" : message.toString();
        if (this.logger instanceof LocationAwareLogger) {
            LocationAwareLogger l = (LocationAwareLogger)this.logger;
            l.log(null, FQCN, level, msg, null, t);
        } else {
            switch (level) {
                case 0: {
                    this.logger.trace(msg, t);
                    break;
                }
                case 10: {
                    this.logger.debug(msg, t);
                    break;
                }
                case 20: {
                    this.logger.info(msg, t);
                    break;
                }
                case 30: {
                    this.logger.warn(msg, t);
                    break;
                }
                case 40: {
                    this.logger.error(msg, t);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown log level " + level);
                }
            }
        }
    }
}

