/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.hawkular.metrics.clients.ptrans.Configuration;
import org.hawkular.metrics.clients.ptrans.Service;
import org.hawkular.metrics.clients.ptrans.backend.MetricsSender;
import org.hawkular.metrics.clients.ptrans.backend.NettyToVertxHandler;
import org.hawkular.metrics.clients.ptrans.collectd.CollectdServer;
import org.hawkular.metrics.clients.ptrans.ganglia.GangliaChannelInitializer;
import org.hawkular.metrics.clients.ptrans.graphite.GraphiteServer;
import org.hawkular.metrics.clients.ptrans.log.PTransLogger;
import org.hawkular.metrics.clients.ptrans.log.PTransLogging;
import org.hawkular.metrics.clients.ptrans.statsd.StatsdChannelInitializer;
import org.hawkular.metrics.clients.ptrans.syslog.TcpChannelInitializer;
import org.hawkular.metrics.clients.ptrans.syslog.UdpChannelInitializer;
import org.hawkular.metrics.clients.ptrans.util.Arguments;

public class PTrans {
    private static final PTransLogger log = PTransLogging.getPTransLogger(PTrans.class);
    private final Configuration configuration;
    private EventLoopGroup group;
    private EventLoopGroup workerGroup;
    private Vertx vertx;
    private NettyToVertxHandler nettyToVertxHandler;
    private String metricsSenderID;

    public PTrans(Configuration configuration) {
        Arguments.checkArgument(configuration != null, "Configuration is null", new Object[0]);
        Arguments.checkArgument(configuration.isValid(), configuration.getValidationMessages().stream().collect(Collectors.joining(", ")), new Object[0]);
        this.configuration = configuration;
    }

    public void start() {
        log.infoStarting();
        this.group = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.vertx = Vertx.vertx();
        this.nettyToVertxHandler = new NettyToVertxHandler(this.vertx.eventBus());
        this.vertx.deployVerticle((Verticle)new MetricsSender(this.configuration), handler -> {
            this.metricsSenderID = (String)handler.result();
        });
        Set<Service> services = this.configuration.getServices();
        ArrayList<ChannelFuture> closeFutures = new ArrayList<ChannelFuture>(services.size());
        if (services.contains((Object)Service.TCP)) {
            ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.group, this.workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.configuration.getTcpPort())).childHandler(new TcpChannelInitializer(this.nettyToVertxHandler));
            ChannelFuture tcpBindFuture = serverBootstrap.bind().syncUninterruptibly();
            log.infoServerListening("Server", "TCP", tcpBindFuture.channel().localAddress());
            closeFutures.add(tcpBindFuture.channel().closeFuture());
        }
        if (services.contains((Object)Service.UDP)) {
            Bootstrap udpBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioDatagramChannel.class)).localAddress(this.configuration.getUdpPort())).handler(new UdpChannelInitializer(this.nettyToVertxHandler));
            ChannelFuture udpBindFuture = udpBootstrap.bind().syncUninterruptibly();
            log.infoServerListening("Syslogd", "UDP", udpBindFuture.channel().localAddress());
            closeFutures.add(udpBindFuture.channel().closeFuture());
        }
        if (services.contains((Object)Service.GANGLIA)) {
            NetworkInterface mcIf;
            try {
                String multicastIfOverride = this.configuration.getMulticastIfOverride();
                if (multicastIfOverride == null) {
                    Inet4Address hostAddr = (Inet4Address)InetAddress.getLocalHost();
                    mcIf = NetworkInterface.getByInetAddress(hostAddr);
                } else {
                    mcIf = NetworkInterface.getByName(multicastIfOverride);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            InetSocketAddress gangliaSocket = new InetSocketAddress(this.configuration.getGangliaGroup(), this.configuration.getGangliaPort());
            Bootstrap gangliaBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.IP_MULTICAST_IF, mcIf)).localAddress(gangliaSocket)).handler(new GangliaChannelInitializer(this.nettyToVertxHandler));
            log.tracef("Ganglia bootstrap is %s", (Object)gangliaBootstrap);
            ChannelFuture gangliaBindFuture = gangliaBootstrap.bind().syncUninterruptibly();
            log.infoServerListening("Ganglia", "UDP", gangliaBindFuture.channel().localAddress());
            DatagramChannel gangliaChannel = (DatagramChannel)gangliaBindFuture.channel();
            gangliaChannel.joinGroup(gangliaSocket, mcIf);
            log.trace("Joined the Ganglia group");
            closeFutures.add(gangliaChannel.closeFuture());
        }
        if (services.contains((Object)Service.STATSD)) {
            Bootstrap statsdBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioDatagramChannel.class)).localAddress(this.configuration.getStatsDport())).handler(new StatsdChannelInitializer(this.nettyToVertxHandler));
            ChannelFuture statsdBindFuture = statsdBootstrap.bind().syncUninterruptibly();
            log.infoServerListening("Statsd", "UDP", statsdBindFuture.channel().localAddress());
            closeFutures.add(statsdBindFuture.channel().closeFuture());
        }
        if (services.contains((Object)Service.GRAPHITE)) {
            this.vertx.deployVerticle((Verticle)new GraphiteServer(this.configuration), handler -> log.infoServerListening("Graphite", "TCP", this.configuration.getGraphitePort()));
        }
        if (services.contains((Object)Service.COLLECTD)) {
            this.vertx.deployVerticle((Verticle)new CollectdServer(this.configuration), handler -> log.infoServerListening("Collectd", "UDP", this.configuration.getCollectdPort()));
        }
        log.infoStarted();
        closeFutures.forEach(ChannelFuture::syncUninterruptibly);
    }

    public void stop() {
        log.infoStopping();
        this.group.shutdownGracefully().syncUninterruptibly();
        this.workerGroup.shutdownGracefully().syncUninterruptibly();
        Set<String> deploymentIDs = this.vertx.deploymentIDs().stream().filter(id -> !this.metricsSenderID.equals(id)).collect(Collectors.toSet());
        CountDownLatch deploymentsLatch = new CountDownLatch(deploymentIDs.size());
        deploymentIDs.forEach(id -> this.vertx.undeploy((String)id, handler -> deploymentsLatch.countDown()));
        try {
            deploymentsLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        CountDownLatch senderLatch = new CountDownLatch(1);
        this.vertx.undeploy(this.metricsSenderID, handler -> senderLatch.countDown());
        try {
            senderLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        CountDownLatch vertxLatch = new CountDownLatch(1);
        this.vertx.close(handler -> vertxLatch.countDown());
        try {
            vertxLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        log.infoStopped();
    }
}

