/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import java.util.List;
import java.util.ListIterator;
import org.hawkular.metrics.client.common.SingleMetric;
import org.hawkular.metrics.clients.ptrans.Configuration;
import org.hawkular.metrics.clients.ptrans.collectd.event.CollectdEventsDecoder;
import org.hawkular.metrics.clients.ptrans.collectd.event.Event;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeResolution;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeSpan;
import org.hawkular.metrics.clients.ptrans.collectd.event.ValueListEvent;
import org.hawkular.metrics.clients.ptrans.collectd.packet.CollectdPacket;
import org.hawkular.metrics.clients.ptrans.collectd.packet.CollectdPacketDecoder;

public class CollectdServer
extends AbstractVerticle {
    private final int port;
    private final CollectdPacketDecoder packetDecoder;
    private final CollectdEventsDecoder eventsDecoder;

    public CollectdServer(Configuration configuration) {
        this.port = configuration.getCollectdPort();
        this.packetDecoder = new CollectdPacketDecoder();
        this.eventsDecoder = new CollectdEventsDecoder();
    }

    @Override
    public void start(Future<Void> startFuture) throws Exception {
        DatagramSocket socket = this.vertx.createDatagramSocket();
        socket.handler(this::handlePacket);
        socket.listen(this.port, "0.0.0.0", result -> {
            if (result.succeeded()) {
                startFuture.complete();
            } else {
                startFuture.fail(result.cause());
            }
        });
    }

    private void handlePacket(DatagramPacket packet) {
        CollectdPacket collectdPacket = this.packetDecoder.decode(packet);
        if (collectdPacket == null) {
            return;
        }
        List<Event> events = this.eventsDecoder.decode(collectdPacket);
        events.forEach(event -> {
            if (event instanceof ValueListEvent) {
                this.handleValueListEvent((ValueListEvent)event);
            }
        });
    }

    private void handleValueListEvent(ValueListEvent event) {
        StringBuilder prefixBuilder = new StringBuilder().append(event.getHost()).append(".").append(event.getPluginName());
        String pluginInstance = event.getPluginInstance();
        if (pluginInstance != null && pluginInstance.length() > 0) {
            prefixBuilder.append(".").append(pluginInstance);
        }
        prefixBuilder.append(".").append(event.getTypeName());
        String typeInstance = event.getTypeInstance();
        if (typeInstance != null && typeInstance.length() > 0) {
            prefixBuilder.append(".").append(typeInstance);
        }
        String prefix = prefixBuilder.toString();
        TimeSpan timeSpan = event.getTimestamp();
        List<Number> values = event.getValues();
        ListIterator<Number> iterator = values.listIterator();
        while (iterator.hasNext()) {
            Number value = iterator.next();
            long timestamp = TimeResolution.toMillis(timeSpan);
            StringBuilder sourceBuilder = new StringBuilder(prefix);
            if (values.size() > 1) {
                sourceBuilder.append(".").append(iterator.previousIndex());
            }
            SingleMetric metric = new SingleMetric(sourceBuilder.toString(), timestamp, value.doubleValue());
            this.vertx.eventBus().publish("singlemetric", metric);
        }
    }
}

