/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.graphite;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetServer;
import io.vertx.core.parsetools.RecordParser;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.client.common.SingleMetric;
import org.hawkular.metrics.clients.ptrans.Configuration;
import org.jboss.logging.Logger;

public class GraphiteServer
extends AbstractVerticle {
    private static final Logger log = Logger.getLogger(GraphiteServer.class);
    private final int port;
    private final RecordParser recordParser;

    public GraphiteServer(Configuration configuration) {
        this.port = configuration.getGraphitePort();
        this.recordParser = RecordParser.newDelimited("\n", this::handleRecord);
    }

    @Override
    public void start(Future<Void> startFuture) throws Exception {
        NetServer tcpServer = this.vertx.createNetServer();
        tcpServer.connectHandler(socket -> socket.handler(this.recordParser::handle));
        tcpServer.listen(this.port, result -> {
            if (result.succeeded()) {
                startFuture.complete();
            } else {
                startFuture.fail(result.cause());
            }
        });
    }

    private void handleRecord(Buffer buf) {
        String msg = buf.toString("UTF-8");
        String[] items = msg.split(" ");
        if (items.length != 3) {
            log.tracef("Unknown data format for '%s', skipping", (Object)msg);
            return;
        }
        String name = items[0];
        double value = Double.parseDouble(items[1]);
        long timestamp = TimeUnit.MILLISECONDS.convert(Long.parseLong(items[2]), TimeUnit.SECONDS);
        SingleMetric metric = new SingleMetric(name, timestamp, value);
        this.vertx.eventBus().publish("singlemetric", metric);
    }
}

