/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans;

import java.util.HashMap;
import java.util.Map;

public enum ServerType {
    METRICS("metrics"),
    HAWKULAR("hawkular");

    private final String externalForm;
    private static final Map<String, ServerType> SERVER_TYPES_BY_ID;

    private ServerType(String externalForm) {
        this.externalForm = externalForm;
    }

    public String getExternalForm() {
        return this.externalForm;
    }

    public static ServerType findByExternalForm(String externalForm) {
        return SERVER_TYPES_BY_ID.get(externalForm);
    }

    static {
        SERVER_TYPES_BY_ID = new HashMap<String, ServerType>();
        for (ServerType service : ServerType.values()) {
            SERVER_TYPES_BY_ID.put(service.externalForm, service);
        }
    }
}

