/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.ganglia;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.acplt.oncrpc.XdrBufferDecodingStream;
import org.hawkular.metrics.client.common.SingleMetric;

public class UdpGangliaDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    protected void decode(ChannelHandlerContext ctx, DatagramPacket in, List<Object> out) throws Exception {
        ByteBuf msg = (ByteBuf)in.content();
        if (msg.readableBytes() < 5) {
            msg.clear();
            ctx.close();
            return;
        }
        short magic = msg.getUnsignedByte(3);
        if (msg.getByte(0) == 0 && msg.getByte(1) == 0 && msg.getByte(2) == 0 && magic == 134) {
            byte[] bytes = new byte[msg.readableBytes()];
            msg.readBytes(bytes);
            XdrBufferDecodingStream stream = new XdrBufferDecodingStream(bytes);
            stream.beginDecoding();
            stream.xdrDecodeInt();
            String host = stream.xdrDecodeString();
            String metricName = stream.xdrDecodeString();
            stream.xdrDecodeInt();
            String format = stream.xdrDecodeString();
            String value = format.endsWith("f") ? String.valueOf(stream.xdrDecodeFloat()) : stream.xdrDecodeString();
            stream.endDecoding();
            try {
                String path = host + "." + metricName;
                Double val = Double.parseDouble(value);
                SingleMetric metric = new SingleMetric(path, System.currentTimeMillis(), val);
                out.add(metric);
            }
            catch (Exception e) {
                e.printStackTrace();
                msg.clear();
                ctx.close();
            }
        }
    }
}

