/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.ws;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;

public class WebSocketFrameImpl
implements WebSocketFrameInternal,
ReferenceCounted {
    private final FrameType type;
    private final boolean isFinalFrame;
    private ByteBuf binaryData;

    public WebSocketFrameImpl() {
        this(null, Unpooled.EMPTY_BUFFER, true);
    }

    public WebSocketFrameImpl(FrameType frameType) {
        this(frameType, Unpooled.EMPTY_BUFFER, true);
    }

    public WebSocketFrameImpl(String textData) {
        this(textData, true);
    }

    public WebSocketFrameImpl(String textData, boolean isFinalFrame) {
        this.type = FrameType.TEXT;
        this.isFinalFrame = isFinalFrame;
        this.binaryData = Unpooled.copiedBuffer(textData, CharsetUtil.UTF_8);
    }

    public WebSocketFrameImpl(FrameType type, ByteBuf binaryData) {
        this(type, binaryData, true);
    }

    public WebSocketFrameImpl(FrameType type, ByteBuf binaryData, boolean isFinalFrame) {
        this.type = type;
        this.isFinalFrame = isFinalFrame;
        this.binaryData = Unpooled.unreleasableBuffer(binaryData);
    }

    @Override
    public boolean isText() {
        return this.type == FrameType.TEXT;
    }

    @Override
    public boolean isBinary() {
        return this.type == FrameType.BINARY;
    }

    @Override
    public boolean isContinuation() {
        return this.type == FrameType.CONTINUATION;
    }

    @Override
    public ByteBuf getBinaryData() {
        return this.binaryData;
    }

    @Override
    public String textData() {
        return this.getBinaryData().toString(CharsetUtil.UTF_8);
    }

    @Override
    public Buffer binaryData() {
        return Buffer.buffer(this.binaryData);
    }

    @Override
    public void setBinaryData(ByteBuf binaryData) {
        if (this.binaryData != null) {
            this.binaryData.release();
        }
        this.binaryData = binaryData;
    }

    @Override
    public void setTextData(String textData) {
        if (this.binaryData != null) {
            this.binaryData.release();
        }
        this.binaryData = Unpooled.copiedBuffer(textData, CharsetUtil.UTF_8);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(type: " + (Object)((Object)this.type) + ", data: " + this.getBinaryData() + ')';
    }

    @Override
    public int refCnt() {
        return this.binaryData.refCnt();
    }

    @Override
    public ReferenceCounted retain() {
        return this.binaryData.retain();
    }

    @Override
    public ReferenceCounted retain(int increment) {
        return this.binaryData.retain(increment);
    }

    @Override
    public boolean release() {
        return this.binaryData.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.binaryData.release(decrement);
    }

    @Override
    public ReferenceCounted touch() {
        this.binaryData.touch();
        return this;
    }

    @Override
    public ReferenceCounted touch(Object hint) {
        this.binaryData.touch(hint);
        return this;
    }

    @Override
    public boolean isFinal() {
        return this.isFinalFrame;
    }

    @Override
    public FrameType type() {
        return this.type;
    }
}

