/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class KeyStoreHelper {
    private static final String DUMMY_PASSWORD = "dummy";
    protected final String password;

    public static KeyStoreHelper create(VertxInternal vertx, KeyCertOptions options) {
        if (options instanceof JksOptions) {
            Supplier<Buffer> value;
            JksOptions jks = (JksOptions)options;
            if (jks.getPath() != null) {
                value = () -> vertx.fileSystem().readFileBlocking(vertx.resolveFile(jks.getPath()).getAbsolutePath());
            } else if (jks.getValue() != null) {
                value = jks::getValue;
            } else {
                return null;
            }
            return new JKSOrPKCS12("JKS", jks.getPassword(), value);
        }
        if (options instanceof PfxOptions) {
            Supplier<Buffer> value;
            PfxOptions pkcs12 = (PfxOptions)options;
            if (pkcs12.getPath() != null) {
                value = () -> vertx.fileSystem().readFileBlocking(vertx.resolveFile(pkcs12.getPath()).getAbsolutePath());
            } else if (pkcs12.getValue() != null) {
                value = pkcs12::getValue;
            } else {
                return null;
            }
            return new JKSOrPKCS12("PKCS12", pkcs12.getPassword(), value);
        }
        if (options instanceof PemKeyCertOptions) {
            PemKeyCertOptions keyCert = (PemKeyCertOptions)options;
            Supplier<Buffer> key = () -> {
                if (keyCert.getKeyPath() != null) {
                    return vertx.fileSystem().readFileBlocking(vertx.resolveFile(keyCert.getKeyPath()).getAbsolutePath());
                }
                if (keyCert.getKeyValue() != null) {
                    return keyCert.getKeyValue();
                }
                throw new RuntimeException("Missing private key");
            };
            Supplier<Buffer> cert = () -> {
                if (keyCert.getCertPath() != null) {
                    return vertx.fileSystem().readFileBlocking(vertx.resolveFile(keyCert.getCertPath()).getAbsolutePath());
                }
                if (keyCert.getCertValue() != null) {
                    return keyCert.getCertValue();
                }
                throw new RuntimeException("Missing X.509 certificate");
            };
            return new KeyCert(DUMMY_PASSWORD, key, cert);
        }
        return null;
    }

    public static KeyStoreHelper create(VertxInternal vertx, TrustOptions options) {
        if (options instanceof KeyCertOptions) {
            return KeyStoreHelper.create(vertx, (KeyCertOptions)((Object)options));
        }
        if (options instanceof PemTrustOptions) {
            PemTrustOptions trustOptions = (PemTrustOptions)options;
            Stream<Buffer> certValues = trustOptions.getCertPaths().stream().map(path -> vertx.resolveFile((String)path).getAbsolutePath()).map(vertx.fileSystem()::readFileBlocking);
            certValues = Stream.concat(certValues, trustOptions.getCertValues().stream());
            return new CA(certValues);
        }
        return null;
    }

    public KeyStoreHelper(String password) {
        this.password = password;
    }

    public KeyManagerFactory getKeyMgrFactory(VertxInternal vertx) throws Exception {
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        fact.getProvider();
        KeyStore ks = this.loadStore(vertx);
        fact.init(ks, this.password != null ? this.password.toCharArray() : null);
        return fact;
    }

    public KeyManager[] getKeyMgrs(VertxInternal vertx) throws Exception {
        return this.getKeyMgrFactory(vertx).getKeyManagers();
    }

    public TrustManagerFactory getTrustMgrFactory(VertxInternal vertx) throws Exception {
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ts = this.loadStore(vertx);
        fact.init(ts);
        return fact;
    }

    public TrustManager[] getTrustMgrs(VertxInternal vertx) throws Exception {
        return this.getTrustMgrFactory(vertx).getTrustManagers();
    }

    public abstract KeyStore loadStore(VertxInternal var1) throws Exception;

    private static List<byte[]> loadPems(Buffer data, String delimiter) throws IOException {
        String pem = data.toString();
        String beginDelimiter = "-----BEGIN " + delimiter + "-----";
        String endDelimiter = "-----END " + delimiter + "-----";
        ArrayList<byte[]> pems = new ArrayList<byte[]>();
        int index = 0;
        while ((index = pem.indexOf(beginDelimiter, index)) != -1) {
            int end = pem.indexOf(endDelimiter, index += beginDelimiter.length());
            if (end == -1) {
                throw new RuntimeException("Missing " + endDelimiter + " delimiter");
            }
            String content = pem.substring(index, end);
            if ((content = content.replaceAll("\\s", "")).length() == 0) {
                throw new RuntimeException("Empty pem file");
            }
            index = end + 1;
            pems.add(Base64.getDecoder().decode(content));
        }
        if (pems.isEmpty()) {
            throw new RuntimeException("Missing " + beginDelimiter + " delimiter");
        }
        return pems;
    }

    private static X509Certificate[] loadCerts(Buffer buffer) throws Exception {
        if (buffer == null) {
            throw new RuntimeException("Missing X.509 certificate path");
        }
        List<byte[]> pems = KeyStoreHelper.loadPems(buffer, "CERTIFICATE");
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(pems.size());
        for (byte[] pem : pems) {
            for (Certificate certificate : certFactory.generateCertificates(new ByteArrayInputStream(pem))) {
                certs.add((X509Certificate)certificate);
            }
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    static class CA
    extends KeyStoreHelper {
        private Stream<Buffer> certValues;

        CA(Stream<Buffer> certValues) {
            super(null);
            this.certValues = certValues;
        }

        @Override
        public KeyStore loadStore(VertxInternal vertx) throws Exception {
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(null, null);
            int count = 0;
            Iterable iterable = this.certValues::iterator;
            for (Buffer certValue : iterable) {
                for (X509Certificate cert : KeyStoreHelper.loadCerts(certValue)) {
                    keyStore.setCertificateEntry("cert-" + count, cert);
                }
            }
            return keyStore;
        }
    }

    static class KeyCert
    extends KeyStoreHelper {
        private Supplier<Buffer> keyValue;
        private Supplier<Buffer> certValue;

        KeyCert(String password, Supplier<Buffer> keyValue, Supplier<Buffer> certValue) {
            super(password);
            this.keyValue = keyValue;
            this.certValue = certValue;
        }

        @Override
        public KeyStore loadStore(VertxInternal vertx) throws Exception {
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(null, null);
            PrivateKey key = this.loadPrivateKey();
            Certificate[] chain = this.loadCerts();
            keyStore.setEntry("dummy-entry", new KeyStore.PrivateKeyEntry(key, chain), new KeyStore.PasswordProtection(KeyStoreHelper.DUMMY_PASSWORD.toCharArray()));
            return keyStore;
        }

        public PrivateKey loadPrivateKey() throws Exception {
            if (this.keyValue == null) {
                throw new RuntimeException("Missing private key path");
            }
            byte[] value = (byte[])KeyStoreHelper.loadPems(this.keyValue.get(), "PRIVATE KEY").get(0);
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
            return rsaKeyFactory.generatePrivate(new PKCS8EncodedKeySpec(value));
        }

        public X509Certificate[] loadCerts() throws Exception {
            return KeyStoreHelper.loadCerts(this.certValue.get());
        }
    }

    static class JKSOrPKCS12
    extends KeyStoreHelper {
        private String type;
        private Supplier<Buffer> value;

        JKSOrPKCS12(String type, String password, Supplier<Buffer> value) {
            super(password);
            this.type = type;
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public KeyStore loadStore(VertxInternal vertx) throws Exception {
            KeyStore ks = KeyStore.getInstance(this.type);
            InputStream in = null;
            try {
                in = new ByteArrayInputStream(this.value.get().getBytes());
                ks.load(in, this.password != null ? this.password.toCharArray() : null);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return ks;
        }
    }
}

