/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLHelper {
    private static final Map<HttpVersion, String> PROTOCOL_NAME_MAPPING = new EnumMap<HttpVersion, String>(HttpVersion.class);
    private static final List<String> DEFAULT_JDK_CIPHER_SUITE;
    private static final Logger log;
    private static final String[] DEFAULT_ENABLED_PROTOCOLS;
    private boolean ssl;
    private KeyCertOptions keyCertOptions;
    private TrustOptions trustOptions;
    private boolean trustAll;
    private ArrayList<String> crlPaths;
    private ArrayList<Buffer> crlValues;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private Set<String> enabledCipherSuites;
    private boolean openSsl;
    private boolean client;
    private boolean useAlpn;
    private List<HttpVersion> applicationProtocols;
    private Set<String> enabledProtocols;
    private String endpointIdentificationAlgorithm = "";
    private SslContext sslContext;
    private boolean openSslSessionCacheEnabled = true;

    public static SSLEngineOptions resolveEngineOptions(TCPSSLOptions options) {
        SSLEngineOptions engineOptions = options.getSslEngineOptions();
        if (engineOptions == null && options.isUseAlpn()) {
            if (JdkSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new JdkSSLEngineOptions();
            } else if (OpenSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new OpenSSLEngineOptions();
            }
        }
        if (engineOptions == null) {
            engineOptions = new JdkSSLEngineOptions();
        } else if (engineOptions instanceof OpenSSLEngineOptions && !OpenSSLEngineOptions.isAvailable()) {
            throw new VertxException("OpenSSL is not available");
        }
        if (options.isUseAlpn()) {
            if (engineOptions instanceof JdkSSLEngineOptions && !JdkSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN not available for JDK SSL/TLS engine");
            }
            if (engineOptions instanceof OpenSSLEngineOptions && !OpenSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN is not available for OpenSSL SSL/TLS engine");
            }
        }
        return engineOptions;
    }

    public SSLHelper(HttpClientOptions options, KeyCertOptions keyCertOptions, TrustOptions trustOptions) {
        SSLEngineOptions sslEngineOptions = SSLHelper.resolveEngineOptions(options);
        this.ssl = options.isSsl();
        this.keyCertOptions = keyCertOptions;
        this.trustOptions = trustOptions;
        this.trustAll = options.isTrustAll();
        this.crlPaths = new ArrayList<String>(options.getCrlPaths());
        this.crlValues = new ArrayList<Buffer>(options.getCrlValues());
        this.enabledCipherSuites = options.getEnabledCipherSuites();
        this.openSsl = sslEngineOptions instanceof OpenSSLEngineOptions;
        this.client = true;
        this.useAlpn = options.isUseAlpn();
        this.enabledProtocols = options.getEnabledSecureTransportProtocols();
        if (options.isVerifyHost()) {
            this.endpointIdentificationAlgorithm = "HTTPS";
        }
        this.openSslSessionCacheEnabled = sslEngineOptions instanceof OpenSSLEngineOptions && ((OpenSSLEngineOptions)sslEngineOptions).isSessionCacheEnabled();
    }

    public SSLHelper(HttpServerOptions options, KeyCertOptions keyCertOptions, TrustOptions trustOptions) {
        SSLEngineOptions sslEngineOptions = SSLHelper.resolveEngineOptions(options);
        this.ssl = options.isSsl();
        this.keyCertOptions = keyCertOptions;
        this.trustOptions = trustOptions;
        this.clientAuth = options.getClientAuth();
        this.crlPaths = options.getCrlPaths() != null ? new ArrayList<String>(options.getCrlPaths()) : null;
        this.crlValues = options.getCrlValues() != null ? new ArrayList<Buffer>(options.getCrlValues()) : null;
        this.enabledCipherSuites = options.getEnabledCipherSuites();
        this.openSsl = sslEngineOptions instanceof OpenSSLEngineOptions;
        this.client = false;
        this.useAlpn = options.isUseAlpn();
        this.enabledProtocols = options.getEnabledSecureTransportProtocols();
        this.openSslSessionCacheEnabled = sslEngineOptions instanceof OpenSSLEngineOptions && ((OpenSSLEngineOptions)sslEngineOptions).isSessionCacheEnabled();
    }

    public SSLHelper(NetClientOptions options, KeyCertOptions keyCertOptions, TrustOptions trustOptions) {
        SSLEngineOptions sslEngineOptions = SSLHelper.resolveEngineOptions(options);
        this.ssl = options.isSsl();
        this.keyCertOptions = keyCertOptions;
        this.trustOptions = trustOptions;
        this.trustAll = options.isTrustAll();
        this.crlPaths = new ArrayList<String>(options.getCrlPaths());
        this.crlValues = new ArrayList<Buffer>(options.getCrlValues());
        this.enabledCipherSuites = options.getEnabledCipherSuites();
        this.openSsl = sslEngineOptions instanceof OpenSSLEngineOptions;
        this.client = true;
        this.useAlpn = false;
        this.enabledProtocols = options.getEnabledSecureTransportProtocols();
        this.endpointIdentificationAlgorithm = options.getHostnameVerificationAlgorithm();
        this.openSslSessionCacheEnabled = sslEngineOptions instanceof OpenSSLEngineOptions && ((OpenSSLEngineOptions)sslEngineOptions).isSessionCacheEnabled();
    }

    public SSLHelper(NetServerOptions options, KeyCertOptions keyCertOptions, TrustOptions trustOptions) {
        SSLEngineOptions sslEngineOptions = SSLHelper.resolveEngineOptions(options);
        this.ssl = options.isSsl();
        this.keyCertOptions = keyCertOptions;
        this.trustOptions = trustOptions;
        this.clientAuth = options.getClientAuth();
        this.crlPaths = options.getCrlPaths() != null ? new ArrayList<String>(options.getCrlPaths()) : null;
        this.crlValues = options.getCrlValues() != null ? new ArrayList<Buffer>(options.getCrlValues()) : null;
        this.enabledCipherSuites = options.getEnabledCipherSuites();
        this.openSsl = sslEngineOptions instanceof OpenSSLEngineOptions;
        this.client = false;
        this.useAlpn = false;
        this.enabledProtocols = options.getEnabledSecureTransportProtocols();
        this.openSslSessionCacheEnabled = options.getSslEngineOptions() instanceof OpenSSLEngineOptions && ((OpenSSLEngineOptions)options.getSslEngineOptions()).isSessionCacheEnabled();
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public List<HttpVersion> getApplicationProtocols() {
        return this.applicationProtocols;
    }

    public SSLHelper setApplicationProtocols(List<HttpVersion> applicationProtocols) {
        this.applicationProtocols = applicationProtocols;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SslContext createContext(VertxInternal vertx) {
        try {
            KeyStoreHelper.KeyCert keyStoreHelper;
            SslContextBuilder builder;
            KeyManagerFactory keyMgrFactory = this.getKeyMgrFactory(vertx);
            TrustManagerFactory trustMgrFactory = this.getTrustMgrFactory(vertx);
            if (this.client) {
                builder = SslContextBuilder.forClient();
                if (keyMgrFactory != null) {
                    if (this.openSsl) {
                        if (!(this.keyCertOptions instanceof PemKeyCertOptions)) throw new VertxException("OpenSSL server key/certificate must be configured with .pem format");
                        keyStoreHelper = (KeyStoreHelper.KeyCert)KeyStoreHelper.create(vertx, this.keyCertOptions);
                        X509Certificate[] certs = keyStoreHelper.loadCerts();
                        PrivateKey privateKey = keyStoreHelper.loadPrivateKey();
                        builder.keyManager(privateKey, certs);
                    } else {
                        builder.keyManager(keyMgrFactory);
                    }
                }
            } else if (this.openSsl) {
                if (!(this.keyCertOptions instanceof PemKeyCertOptions)) throw new VertxException("OpenSSL server key/certificate must be configured with .pem format");
                keyStoreHelper = (KeyStoreHelper.KeyCert)KeyStoreHelper.create(vertx, this.keyCertOptions);
                X509Certificate[] certs = keyStoreHelper.loadCerts();
                PrivateKey privateKey = keyStoreHelper.loadPrivateKey();
                builder = SslContextBuilder.forServer(privateKey, certs);
            } else {
                if (keyMgrFactory == null) {
                    throw new VertxException("Key/certificate is mandatory for SSL");
                }
                builder = SslContextBuilder.forServer(keyMgrFactory);
            }
            Collection<String> cipherSuites = this.enabledCipherSuites;
            if (this.openSsl) {
                builder.sslProvider(SslProvider.OPENSSL);
                if (cipherSuites == null || cipherSuites.isEmpty()) {
                    cipherSuites = OpenSsl.availableCipherSuites();
                }
            } else {
                builder.sslProvider(SslProvider.JDK);
                if (cipherSuites == null || cipherSuites.isEmpty()) {
                    cipherSuites = DEFAULT_JDK_CIPHER_SUITE;
                }
            }
            if (trustMgrFactory != null) {
                builder.trustManager(trustMgrFactory);
            }
            if (cipherSuites != null && cipherSuites.size() > 0) {
                builder.ciphers(cipherSuites);
            }
            if (!this.useAlpn || this.applicationProtocols == null || this.applicationProtocols.size() <= 0) return builder.build();
            builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, this.applicationProtocols.stream().map(PROTOCOL_NAME_MAPPING::get).collect(Collectors.toList())));
            return builder.build();
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    private KeyManagerFactory getKeyMgrFactory(VertxInternal vertx) throws Exception {
        return this.keyCertOptions == null ? null : this.keyCertOptions.getKeyManagerFactory(vertx);
    }

    private TrustManagerFactory getTrustMgrFactory(VertxInternal vertx) throws Exception {
        TrustManagerFactory fact;
        block8: {
            block9: {
                if (this.trustAll) {
                    final TrustManager[] mgrs = new TrustManager[]{SSLHelper.createTrustAllTrustManager()};
                    fact = new SimpleTrustManagerFactory(){

                        @Override
                        protected void engineInit(KeyStore keyStore) throws Exception {
                        }

                        @Override
                        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
                        }

                        @Override
                        protected TrustManager[] engineGetTrustManagers() {
                            return (TrustManager[])mgrs.clone();
                        }
                    };
                } else if (this.trustOptions != null) {
                    fact = this.trustOptions.getTrustManagerFactory(vertx);
                } else {
                    return null;
                }
                if (this.crlPaths == null || this.crlValues == null) break block8;
                if (this.crlPaths.size() > 0) break block9;
                if (this.crlValues.size() <= 0) break block8;
            }
            Stream<Buffer> tmp = this.crlPaths.stream().map(path -> vertx.resolveFile((String)path).getAbsolutePath()).map(vertx.fileSystem()::readFileBlocking);
            tmp = Stream.concat(tmp, this.crlValues.stream());
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            ArrayList<CRL> crls = new ArrayList<CRL>();
            for (Buffer crlValue : tmp.collect(Collectors.toList())) {
                crls.addAll(certificatefactory.generateCRLs(new ByteArrayInputStream(crlValue.getBytes())));
            }
            final TrustManager[] mgrs = SSLHelper.createUntrustRevokedCertTrustManager(fact.getTrustManagers(), crls);
            fact = new SimpleTrustManagerFactory(){

                @Override
                protected void engineInit(KeyStore keyStore) throws Exception {
                }

                @Override
                protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
                }

                @Override
                protected TrustManager[] engineGetTrustManagers() {
                    return (TrustManager[])mgrs.clone();
                }
            };
        }
        return fact;
    }

    private static TrustManager[] createUntrustRevokedCertTrustManager(TrustManager[] trustMgrs, final ArrayList<CRL> crls) {
        trustMgrs = (TrustManager[])trustMgrs.clone();
        for (int i = 0; i < trustMgrs.length; ++i) {
            TrustManager trustMgr = trustMgrs[i];
            if (!(trustMgr instanceof X509TrustManager)) continue;
            final X509TrustManager x509TrustManager = (X509TrustManager)trustMgr;
            trustMgrs[i] = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkClientTrusted(x509Certificates, s);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkServerTrusted(x509Certificates, s);
                }

                private void checkRevoked(X509Certificate[] x509Certificates) throws CertificateException {
                    for (X509Certificate cert : x509Certificates) {
                        for (CRL crl : crls) {
                            if (!crl.isRevoked(cert)) continue;
                            throw new CertificateException("Certificate revoked");
                        }
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return x509TrustManager.getAcceptedIssuers();
                }
            };
        }
        return trustMgrs;
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    private SslHandler createHandler(SSLEngine engine, boolean client) {
        if (this.enabledCipherSuites != null && !this.enabledCipherSuites.isEmpty()) {
            String[] toUse = this.enabledCipherSuites.toArray(new String[this.enabledCipherSuites.size()]);
            engine.setEnabledCipherSuites(toUse);
        }
        engine.setUseClientMode(client);
        LinkedHashSet<String> protocols = new LinkedHashSet<String>(Arrays.asList(DEFAULT_ENABLED_PROTOCOLS));
        protocols.retainAll(Arrays.asList(engine.getEnabledProtocols()));
        if (this.enabledProtocols != null && !this.enabledProtocols.isEmpty() && !protocols.isEmpty()) {
            protocols.retainAll(this.enabledProtocols);
            if (protocols.isEmpty()) {
                log.warn("no SSL/TLS protocols are enabled due to configuration restrictions");
            }
        }
        engine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        if (!client) {
            switch (this.getClientAuth()) {
                case REQUEST: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    engine.setNeedClientAuth(false);
                }
            }
        } else if (!this.endpointIdentificationAlgorithm.isEmpty()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
            engine.setSSLParameters(sslParameters);
        }
        return new SslHandler(engine);
    }

    public SslContext getContext(VertxInternal vertx) {
        if (this.sslContext == null) {
            SSLSessionContext sslSessionContext;
            this.sslContext = this.createContext(vertx);
            if (this.sslContext instanceof OpenSslServerContext && (sslSessionContext = this.sslContext.sessionContext()) instanceof OpenSslServerSessionContext) {
                ((OpenSslServerSessionContext)sslSessionContext).setSessionCacheEnabled(this.openSslSessionCacheEnabled);
            }
        }
        return this.sslContext;
    }

    public synchronized void validate(VertxInternal vertx) {
        if (this.ssl) {
            this.getContext(vertx);
        }
    }

    public SslHandler createSslHandler(VertxInternal vertx, String host, int port) {
        SSLEngine engine = this.getContext(vertx).newEngine(ByteBufAllocator.DEFAULT, host, port);
        return this.createHandler(engine, this.client);
    }

    public SslHandler createSslHandler(VertxInternal vertx) {
        SSLEngine engine = this.getContext(vertx).newEngine(ByteBufAllocator.DEFAULT);
        return this.createHandler(engine, this.client);
    }

    static {
        ArrayList suite = new ArrayList();
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            SSLEngine engine = context.createSSLEngine();
            Collections.addAll(suite, engine.getEnabledCipherSuites());
        }
        catch (Throwable e) {
            suite = null;
        }
        DEFAULT_JDK_CIPHER_SUITE = suite != null ? Collections.unmodifiableList(suite) : null;
        PROTOCOL_NAME_MAPPING.put(HttpVersion.HTTP_2, "h2");
        PROTOCOL_NAME_MAPPING.put(HttpVersion.HTTP_1_1, "http/1.1");
        PROTOCOL_NAME_MAPPING.put(HttpVersion.HTTP_1_0, "http/1.0");
        log = LoggerFactory.getLogger(SSLHelper.class);
        DEFAULT_ENABLED_PROTOCOLS = new String[]{"SSLv2Hello", "TLSv1", "TLSv1.1", "TLSv1.2"};
    }
}

