/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.hawkular.VertxHawkularOptions;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.MetricSupplier;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class Scheduler {
    private final Vertx vertx;
    private final Handler<List<DataPoint>> sender;
    private final List<MetricSupplier> suppliers;
    private long timerId;

    public Scheduler(Vertx vertx, VertxHawkularOptions options, Context context, Handler<List<DataPoint>> sender) {
        this.vertx = vertx;
        this.sender = sender;
        this.suppliers = new CopyOnWriteArrayList<MetricSupplier>();
        context.runOnContext(aVoid -> {
            this.timerId = vertx.setPeriodic(TimeUnit.MILLISECONDS.convert(options.getSchedule(), TimeUnit.SECONDS), this::collectAndSend);
        });
    }

    private void collectAndSend(Long timerId) {
        this.suppliers.forEach(supplier -> this.sender.handle(supplier.collect()));
    }

    public void register(MetricSupplier supplier) {
        this.suppliers.add(supplier);
    }

    public void unregister(MetricSupplier supplier) {
        this.suppliers.remove(supplier);
    }

    public void stop() {
        this.vertx.cancelTimer(this.timerId);
    }
}

