/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import io.vertx.core.datagram.DatagramPacket;
import java.math.BigInteger;
import java.util.ArrayList;
import org.hawkular.metrics.clients.ptrans.collectd.event.DataType;
import org.hawkular.metrics.clients.ptrans.collectd.packet.CollectdPacket;
import org.hawkular.metrics.clients.ptrans.collectd.packet.NumericPart;
import org.hawkular.metrics.clients.ptrans.collectd.packet.Part;
import org.hawkular.metrics.clients.ptrans.collectd.packet.PartType;
import org.hawkular.metrics.clients.ptrans.collectd.packet.StringPart;
import org.hawkular.metrics.clients.ptrans.collectd.packet.ValuePart;
import org.hawkular.metrics.clients.ptrans.collectd.packet.Values;
import org.jboss.logging.Logger;

public final class CollectdPacketDecoder {
    private static final Logger log = Logger.getLogger(CollectdPacketDecoder.class);

    public CollectdPacket decode(DatagramPacket packet) {
        long start = System.currentTimeMillis();
        ByteBuf content = packet.data().getByteBuf();
        ArrayList parts = new ArrayList(100);
        while (this.hasReadableBytes(content, 4)) {
            Part part;
            short partTypeId = content.readShort();
            PartType partType = PartType.findById(partTypeId);
            int partLength = content.readUnsignedShort();
            int valueLength = partLength - 4;
            if (!this.hasReadableBytes(content, valueLength)) break;
            if (partType == null) {
                content.skipBytes(valueLength);
                continue;
            }
            switch (partType) {
                case HOST: 
                case PLUGIN: 
                case PLUGIN_INSTANCE: 
                case TYPE: 
                case INSTANCE: {
                    part = new StringPart(partType, this.readStringPartContent(content, valueLength));
                    break;
                }
                case TIME: 
                case TIME_HIGH_RESOLUTION: 
                case INTERVAL: 
                case INTERVAL_HIGH_RESOLUTION: {
                    part = new NumericPart(partType, this.readNumericPartContent(content));
                    break;
                }
                case VALUES: {
                    part = new ValuePart(partType, this.readValuePartContent(content, valueLength));
                    break;
                }
                default: {
                    part = null;
                    content.skipBytes(valueLength);
                }
            }
            if (part == null) continue;
            log.tracef("Decoded part: %s", (Object)part);
            parts.add(part);
        }
        if (log.isTraceEnabled()) {
            long stop = System.currentTimeMillis();
            log.tracef("Decoded datagram in %d ms", stop - start);
        }
        if (parts.size() > 0) {
            return new CollectdPacket(parts);
        }
        log.trace("No parts decoded, no CollectdPacket output");
        return null;
    }

    private boolean hasReadableBytes(ByteBuf content, int count) {
        return content.readableBytes() >= count;
    }

    private String readStringPartContent(ByteBuf content, int length) {
        String string = content.toString(content.readerIndex(), length - 1, CharsetUtil.US_ASCII);
        content.skipBytes(length);
        return string;
    }

    private long readNumericPartContent(ByteBuf content) {
        return content.readLong();
    }

    private Values readValuePartContent(ByteBuf content, int length) {
        int beginIndex = content.readerIndex();
        int total = content.readUnsignedShort();
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(total);
        for (int i = 0; i < total; ++i) {
            byte sampleTypeId = content.readByte();
            dataTypes.add(DataType.findById(sampleTypeId));
        }
        ArrayList<Number> data = new ArrayList<Number>(total);
        block6: for (DataType dataType : dataTypes) {
            switch (dataType) {
                case COUNTER: 
                case ABSOLUTE: {
                    byte[] valueBytes = new byte[8];
                    content.readBytes(valueBytes);
                    data.add(new BigInteger(1, valueBytes));
                    continue block6;
                }
                case DERIVE: {
                    data.add(content.readLong());
                    continue block6;
                }
                case GAUGE: {
                    data.add(Double.longBitsToDouble(ByteBufUtil.swapLong(content.readLong())));
                    continue block6;
                }
            }
            log.tracef("Skipping unknown data type: %s", (Object)dataType);
        }
        int readCount = content.readerIndex() - beginIndex;
        if (length > readCount) {
            content.skipBytes(readCount - length);
        }
        return new Values(dataTypes, data);
    }
}

