/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.net.SocketAddress;
import io.vertx.ext.hawkular.impl.CounterPoint;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.GaugePoint;
import io.vertx.ext.hawkular.impl.HttpServerMetricsImpl;
import io.vertx.ext.hawkular.impl.MetricSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class HttpServerMetricsSupplier
implements MetricSupplier {
    private final String baseName;
    private final Set<HttpServerMetricsImpl> metricsSet = new CopyOnWriteArraySet<HttpServerMetricsImpl>();

    public HttpServerMetricsSupplier(String prefix) {
        this.baseName = prefix + (prefix.isEmpty() ? "" : ".") + "vertx.http.server.";
    }

    @Override
    public List<DataPoint> collect() {
        long timestamp = System.currentTimeMillis();
        HashMap<SocketAddress, Long> processingTime = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> requestCount = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> requests = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> httpConnections = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> wsConnections = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> bytesReceived = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> bytesSent = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> errorCount = new HashMap<SocketAddress, Long>();
        for (HttpServerMetricsImpl httpServerMetrics : this.metricsSet) {
            SocketAddress serverAddress = httpServerMetrics.getServerAddress();
            this.merge(processingTime, serverAddress, httpServerMetrics.getProcessingTime());
            this.merge(requestCount, serverAddress, httpServerMetrics.getRequestCount());
            this.merge(requests, serverAddress, httpServerMetrics.getRequests());
            this.merge(httpConnections, serverAddress, httpServerMetrics.getHttpConnections());
            this.merge(wsConnections, serverAddress, httpServerMetrics.getWsConnections());
            this.merge(bytesReceived, serverAddress, httpServerMetrics.getBytesReceived());
            this.merge(bytesSent, serverAddress, httpServerMetrics.getBytesSent());
            this.merge(errorCount, serverAddress, httpServerMetrics.getErrorCount());
        }
        ArrayList<DataPoint> res = new ArrayList<DataPoint>();
        res.addAll(this.counters("processingTime", timestamp, processingTime));
        res.addAll(this.counters("requestCount", timestamp, requestCount));
        res.addAll(this.gauges("requests", timestamp, requests));
        res.addAll(this.gauges("httpConnections", timestamp, httpConnections));
        res.addAll(this.gauges("wsConnections", timestamp, wsConnections));
        res.addAll(this.counters("bytesReceived", timestamp, bytesReceived));
        res.addAll(this.counters("bytesSent", timestamp, bytesSent));
        res.addAll(this.counters("errorCount", timestamp, errorCount));
        return res;
    }

    private void merge(Map<SocketAddress, Long> values, SocketAddress serverAddress, Long value) {
        values.merge(serverAddress, value, Long::sum);
    }

    private List<DataPoint> gauges(String id, long timestamp, Map<SocketAddress, Long> values) {
        ArrayList<DataPoint> res = new ArrayList<DataPoint>(values.size());
        values.forEach((address, count) -> {
            String name = this.baseName + address.host() + ":" + address.port() + "." + id;
            res.add(new GaugePoint(name, timestamp, count.longValue()));
        });
        return res;
    }

    private List<DataPoint> counters(String id, long timestamp, Map<SocketAddress, Long> values) {
        ArrayList<DataPoint> res = new ArrayList<DataPoint>(values.size());
        values.forEach((address, count) -> {
            String name = this.baseName + address.host() + ":" + address.port() + "." + id;
            res.add(new CounterPoint(name, timestamp, (long)count));
        });
        return res;
    }

    public void register(HttpServerMetricsImpl httpServerMetrics) {
        this.metricsSet.add(httpServerMetrics);
    }

    public void unregister(HttpServerMetricsImpl httpServerMetrics) {
        this.metricsSet.remove(httpServerMetrics);
    }
}

