/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd.packet;

import java.util.HashMap;
import java.util.Map;

public enum PartType {
    HOST(0),
    TIME(1),
    TIME_HIGH_RESOLUTION(8),
    PLUGIN(2),
    PLUGIN_INSTANCE(3),
    TYPE(4),
    INSTANCE(5),
    VALUES(6),
    INTERVAL(7),
    INTERVAL_HIGH_RESOLUTION(9);

    private short id;
    private static final Map<Short, PartType> TYPE_BY_ID;

    private PartType(short id) {
        this.id = id;
    }

    public short getId() {
        return this.id;
    }

    public static PartType findById(short id) {
        return TYPE_BY_ID.get(id);
    }

    static {
        TYPE_BY_ID = new HashMap<Short, PartType>();
        for (PartType partType : PartType.values()) {
            TYPE_BY_ID.put(partType.id, partType);
        }
    }

    private static class PartTypeId {
        private static final short HOST = 0;
        private static final short TIME = 1;
        private static final short TIME_HIGH_RESOLUTION = 8;
        private static final short PLUGIN = 2;
        private static final short PLUGIN_INSTANCE = 3;
        private static final short TYPE = 4;
        private static final short INSTANCE = 5;
        private static final short VALUES = 6;
        private static final short INTERVAL = 7;
        private static final short INTERVAL_HIGH_RESOLUTION = 9;

        private PartTypeId() {
        }
    }
}

