/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.vertx.core.http.impl.AssembledLastHttpContent;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;
import java.util.Map;

public abstract class VertxHttpHandler<C extends ConnectionBase>
extends VertxHandler<C> {
    protected Map<Channel, C> connectionMap;
    protected final Channel ch;
    protected C conn;

    private static ByteBuf safeBuffer(ByteBufHolder holder, ByteBufAllocator allocator) {
        return VertxHttpHandler.safeBuffer(holder.content(), allocator);
    }

    protected VertxHttpHandler(Map<Channel, C> connectionMap, Channel ch) {
        this.connectionMap = connectionMap;
        this.ch = ch;
    }

    @Override
    protected C getConnection() {
        return this.conn;
    }

    @Override
    protected C removeConnection() {
        this.connectionMap.remove(this.ch);
        C conn = this.conn;
        this.conn = null;
        return conn;
    }

    @Override
    protected void channelRead(C connection, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        if (connection != null) {
            context.executeFromIO(() -> this.doMessageReceived(connection, chctx, msg));
        } else {
            try {
                this.doMessageReceived(null, chctx, msg);
            }
            catch (Throwable t) {
                chctx.pipeline().fireExceptionCaught(t);
            }
        }
    }

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            ByteBuf buf = content.content();
            if (buf != Unpooled.EMPTY_BUFFER && buf.isDirect()) {
                ByteBuf newBuf = VertxHttpHandler.safeBuffer(content, allocator);
                if (msg instanceof LastHttpContent) {
                    LastHttpContent last = (LastHttpContent)msg;
                    return new AssembledLastHttpContent(newBuf, last.trailingHeaders(), last.getDecoderResult());
                }
                return new DefaultHttpContent(newBuf);
            }
        } else if (msg instanceof WebSocketFrame) {
            FrameType frameType;
            ByteBuf payload = VertxHttpHandler.safeBuffer((WebSocketFrame)msg, allocator);
            boolean isFinal = ((WebSocketFrame)msg).isFinalFragment();
            if (msg instanceof BinaryWebSocketFrame) {
                frameType = FrameType.BINARY;
            } else if (msg instanceof CloseWebSocketFrame) {
                frameType = FrameType.CLOSE;
            } else if (msg instanceof PingWebSocketFrame) {
                frameType = FrameType.PING;
            } else if (msg instanceof PongWebSocketFrame) {
                frameType = FrameType.PONG;
            } else if (msg instanceof TextWebSocketFrame) {
                frameType = FrameType.TEXT;
            } else if (msg instanceof ContinuationWebSocketFrame) {
                frameType = FrameType.CONTINUATION;
            } else {
                throw new IllegalStateException("Unsupported websocket msg " + msg);
            }
            return new WebSocketFrameImpl(frameType, payload, isFinal);
        }
        return msg;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof WebSocketFrameInternal) {
            WebSocketFrameInternal frame = (WebSocketFrameInternal)msg;
            ByteBuf buf = frame.getBinaryData();
            if (buf != Unpooled.EMPTY_BUFFER) {
                buf = VertxHttpHandler.safeBuffer(buf, ctx.alloc());
            }
            switch (frame.type()) {
                case BINARY: {
                    msg = new BinaryWebSocketFrame(frame.isFinal(), 0, buf);
                    break;
                }
                case TEXT: {
                    msg = new TextWebSocketFrame(frame.isFinal(), 0, buf);
                    break;
                }
                case CLOSE: {
                    msg = new CloseWebSocketFrame(true, 0, buf);
                    break;
                }
                case CONTINUATION: {
                    msg = new ContinuationWebSocketFrame(frame.isFinal(), 0, buf);
                    break;
                }
                case PONG: {
                    msg = new PongWebSocketFrame(buf);
                    break;
                }
                case PING: {
                    msg = new PingWebSocketFrame(buf);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported websocket msg " + msg);
                }
            }
        }
        ctx.write(msg, promise);
    }

    protected abstract void doMessageReceived(C var1, ChannelHandlerContext var2, Object var3) throws Exception;
}

