/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.VertxHttpHandler;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import java.util.Map;

class ClientHandler
extends VertxHttpHandler<ClientConnection> {
    private boolean closeFrameSent;
    private ContextImpl context;

    public ClientHandler(Channel ch, ContextImpl context, Map<Channel, ClientConnection> connectionMap) {
        super(connectionMap, ch);
        this.context = context;
    }

    @Override
    protected ContextImpl getContext(ClientConnection connection) {
        return this.context;
    }

    @Override
    protected void doMessageReceived(ClientConnection conn, ChannelHandlerContext ctx, Object msg) {
        if (conn == null) {
            return;
        }
        boolean valid = false;
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            DecoderResult result = response.decoderResult();
            if (result.isFailure()) {
                conn.handleException(result.cause());
                conn.close();
                return;
            }
            conn.handleResponse(response);
            valid = true;
        }
        if (msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            if (chunk.content().isReadable()) {
                Buffer buff = Buffer.buffer(chunk.content().slice());
                conn.handleResponseChunk(buff);
            }
            if (chunk instanceof LastHttpContent) {
                conn.handleResponseEnd((LastHttpContent)chunk);
            }
            valid = true;
        } else if (msg instanceof WebSocketFrameInternal) {
            WebSocketFrameInternal frame = (WebSocketFrameInternal)msg;
            switch (frame.type()) {
                case BINARY: 
                case CONTINUATION: 
                case TEXT: {
                    conn.handleWsFrame(frame);
                    break;
                }
                case PING: {
                    ctx.writeAndFlush(new WebSocketFrameImpl(FrameType.PONG, frame.getBinaryData()));
                    break;
                }
                case PONG: {
                    break;
                }
                case CLOSE: {
                    if (this.closeFrameSent) break;
                    ctx.writeAndFlush(frame).addListener(ChannelFutureListener.CLOSE);
                    this.closeFrameSent = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid type: " + (Object)((Object)frame.type()));
                }
            }
            valid = true;
        }
        if (!valid) {
            throw new IllegalStateException("Invalid object " + msg);
        }
    }
}

