/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.ext.hawkular.impl.CounterPoint;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.GaugePoint;
import io.vertx.ext.hawkular.impl.MetricSupplier;
import io.vertx.ext.hawkular.impl.PoolMetricsImpl;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NamedPoolMetricsSupplier
implements MetricSupplier {
    private final Set<PoolMetricsImpl> metricsSet = new CopyOnWriteArraySet<PoolMetricsImpl>();
    private final String baseName;

    public NamedPoolMetricsSupplier(String prefix) {
        this.baseName = prefix + (prefix.isEmpty() ? "" : ".") + "vertx.pool.";
    }

    @Override
    public List<DataPoint> collect() {
        long timestamp = System.currentTimeMillis();
        return this.metricsSet.stream().flatMap(poolMetrics -> {
            String base = this.baseName + poolMetrics.getPoolType() + "." + poolMetrics.getPoolName() + ".";
            Stream.Builder<CounterPoint> dataPoints = Stream.builder().add(new CounterPoint(base + "delay", timestamp, poolMetrics.getDelay())).add((CounterPoint)((Object)new GaugePoint(base + "queued", timestamp, poolMetrics.getQueued()))).add(new CounterPoint(base + "queuedCount", timestamp, poolMetrics.getQueuedCount())).add(new CounterPoint(base + "usage", timestamp, poolMetrics.getUsage())).add((CounterPoint)((Object)new GaugePoint(base + "inUse", timestamp, poolMetrics.getInUse()))).add(new CounterPoint(base + "completed", timestamp, poolMetrics.getCompleted()));
            if (poolMetrics.getMaxPoolSize() > 0) {
                dataPoints.add((CounterPoint)((Object)new GaugePoint(base + "maxPoolSize", timestamp, poolMetrics.getMaxPoolSize()))).add((CounterPoint)((Object)new GaugePoint(base + "poolRatio", timestamp, poolMetrics.getUsageRatio())));
            }
            return dataPoints.build();
        }).collect(Collectors.toList());
    }

    public void register(PoolMetricsImpl poolMetrics) {
        this.metricsSet.add(poolMetrics);
    }

    public void unregister(PoolMetricsImpl poolMetrics) {
        this.metricsSet.remove(poolMetrics);
    }
}

