/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.ext.hawkular.impl.NamedPoolMetricsSupplier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class PoolMetricsImpl
implements PoolMetrics<Long> {
    private final NamedPoolMetricsSupplier namedPoolMetricsSupplier;
    private final String poolType;
    private final String poolName;
    private final int maxPoolSize;
    private final LongAdder delay = new LongAdder();
    private final LongAdder queued = new LongAdder();
    private final LongAdder queuedCount = new LongAdder();
    private final LongAdder usage = new LongAdder();
    private final LongAdder inUse = new LongAdder();
    private final LongAdder completed = new LongAdder();

    public PoolMetricsImpl(NamedPoolMetricsSupplier namedPoolMetricsSupplier, String poolType, String poolName, int maxPoolSize) {
        this.namedPoolMetricsSupplier = namedPoolMetricsSupplier;
        this.poolType = poolType;
        this.poolName = poolName;
        this.maxPoolSize = maxPoolSize;
        namedPoolMetricsSupplier.register(this);
    }

    @Override
    public Long submitted() {
        this.queued.increment();
        this.queuedCount.increment();
        return System.nanoTime();
    }

    @Override
    public void rejected(Long submitted) {
        this.queued.decrement();
    }

    @Override
    public Long begin(Long submitted) {
        long time = System.nanoTime();
        this.delay.add(time - submitted);
        this.queued.decrement();
        this.inUse.increment();
        return time;
    }

    @Override
    public void end(Long begin, boolean succeeded) {
        this.usage.add(System.nanoTime() - begin);
        this.completed.increment();
        this.inUse.decrement();
    }

    public String getPoolType() {
        return this.poolType;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getDelay() {
        return TimeUnit.MILLISECONDS.convert(this.delay.sum(), TimeUnit.NANOSECONDS);
    }

    public long getQueued() {
        return this.queued.sum();
    }

    public long getQueuedCount() {
        return this.queuedCount.sum();
    }

    public long getUsage() {
        return TimeUnit.MILLISECONDS.convert(this.usage.sum(), TimeUnit.NANOSECONDS);
    }

    public long getInUse() {
        return this.inUse.sum();
    }

    public long getCompleted() {
        return this.completed.sum();
    }

    public double getUsageRatio() {
        return this.maxPoolSize > 0 ? (double)this.getInUse() / (double)this.maxPoolSize : -1.0;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
        this.namedPoolMetricsSupplier.unregister(this);
    }
}

