/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd.event;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeSpan;

public enum TimeResolution {
    SECONDS,
    HIGH_RES;

    private static final double HIGH_RES_PRECISION;

    public static long toMillis(TimeSpan timeSpan) {
        return TimeResolution.toMillis(timeSpan.getValue(), timeSpan.getResolution());
    }

    public static long toMillis(long val, TimeResolution resolution) {
        if (resolution == SECONDS) {
            return TimeUnit.MILLISECONDS.convert(val, TimeUnit.SECONDS);
        }
        return (long)(1000.0 * (double)val / HIGH_RES_PRECISION);
    }

    public static Date toDate(TimeSpan timestamp) {
        return TimeResolution.toDate(timestamp.getValue(), timestamp.getResolution());
    }

    public static Date toDate(long timestamp, TimeResolution resolution) {
        return new Date(TimeResolution.toMillis(timestamp, resolution));
    }

    static {
        HIGH_RES_PRECISION = Math.pow(2.0, 30.0);
    }
}

