/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.CharsetUtil;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.FileStreamChannel;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

class VertxHttp2NetSocket<C extends Http2ConnectionBase>
extends VertxHttp2Stream<C>
implements NetSocket {
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> drainHandler;

    public VertxHttp2NetSocket(C conn, Http2Stream stream, boolean writable) {
        super(conn, stream, writable);
    }

    @Override
    void handleEnd(MultiMap trailers) {
        try {
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
        finally {
            this.end();
        }
    }

    @Override
    void handleData(Buffer buf) {
        if (this.dataHandler != null) {
            this.dataHandler.handle(buf);
        }
    }

    @Override
    void handleReset(long errorCode) {
        this.handleException(new StreamResetException(errorCode));
    }

    @Override
    void handleException(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(cause);
        }
    }

    @Override
    void handleClose() {
        if (this.closeHandler != null) {
            this.closeHandler.handle(null);
        }
    }

    @Override
    void handleInterestedOpsChanged() {
        Handler<Void> handler = this.drainHandler;
        if (handler != null && !this.writeQueueFull()) {
            handler.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket handler(Handler<Buffer> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.dataHandler = handler;
            return this;
        }
    }

    @Override
    public NetSocket pause() {
        return this;
    }

    @Override
    public NetSocket resume() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket endHandler(Handler<Void> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket write(Buffer data) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.writeData(data.getByteBuf(), false);
            return this;
        }
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket drainHandler(Handler<Void> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.drainHandler = handler;
            return this;
        }
    }

    @Override
    public boolean writeQueueFull() {
        return this.isNotWritable();
    }

    @Override
    public String writeHandlerID() {
        return null;
    }

    @Override
    public NetSocket write(String str) {
        return this.write(str, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket write(String str, String enc) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            Charset cs = enc != null ? Charset.forName(enc) : CharsetUtil.UTF_8;
            this.writeData(Unpooled.copiedBuffer(str, cs), false);
            return this;
        }
    }

    @Override
    public NetSocket sendFile(String filename, long offset, long length) {
        return this.sendFile(filename, offset, length, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            RandomAccessFile raf;
            ContextImpl resultCtx = resultHandler != null ? this.vertx.getOrCreateContext() : null;
            File file = this.vertx.resolveFile(filename);
            if (!file.exists()) {
                if (resultHandler != null) {
                    resultCtx.runOnContext(v -> resultHandler.handle(Future.failedFuture(new FileNotFoundException())));
                }
                return this;
            }
            try {
                raf = new RandomAccessFile(file, "r");
            }
            catch (IOException e) {
                if (resultHandler != null) {
                    resultCtx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
                }
                return this;
            }
            long contentLength = Math.min(length, file.length() - offset);
            FileStreamChannel fileChannel = new FileStreamChannel(ar -> {
                if (resultHandler != null) {
                    resultCtx.runOnContext(v -> resultHandler.handle(Future.succeededFuture()));
                }
            }, this, offset, contentLength);
            this.drainHandler((Handler)fileChannel.drainHandler);
            this.handlerContext.channel().eventLoop().register(fileChannel);
            fileChannel.pipeline().fireUserEventTriggered(raf);
        }
        return this;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.writeData(Unpooled.EMPTY_BUFFER, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Buffer buffer) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.writeData(buffer.getByteBuf(), true);
        }
    }

    @Override
    public void close() {
        this.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket closeHandler(@Nullable Handler<Void> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.closeHandler = handler;
            return this;
        }
    }

    @Override
    public NetSocket upgradeToSsl(Handler<Void> handler) {
        throw new UnsupportedOperationException("Cannot upgrade HTTP/2 stream to SSL");
    }

    @Override
    public boolean isSsl() {
        return this.conn.isSsl();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.getPeerCertificateChain();
    }
}

