/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.net.SocketAddress;
import io.vertx.ext.hawkular.impl.CounterPoint;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.GaugePoint;
import io.vertx.ext.hawkular.impl.MetricSupplier;
import io.vertx.ext.hawkular.impl.NetServerMetricsImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class NetServerMetricsSupplier
implements MetricSupplier {
    private final String baseName;
    private final Set<NetServerMetricsImpl> metricsSet = new CopyOnWriteArraySet<NetServerMetricsImpl>();

    public NetServerMetricsSupplier(String prefix) {
        this.baseName = prefix + (prefix.isEmpty() ? "" : ".") + "vertx.net.server.";
    }

    @Override
    public List<DataPoint> collect() {
        long timestamp = System.currentTimeMillis();
        HashMap<SocketAddress, Long> connections = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> bytesReceived = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> bytesSent = new HashMap<SocketAddress, Long>();
        HashMap<SocketAddress, Long> errorCount = new HashMap<SocketAddress, Long>();
        for (NetServerMetricsImpl netServerMetrics : this.metricsSet) {
            SocketAddress serverAddress = netServerMetrics.getServerAddress();
            this.merge(connections, serverAddress, netServerMetrics.getConnections());
            this.merge(bytesReceived, serverAddress, netServerMetrics.getBytesReceived());
            this.merge(bytesSent, serverAddress, netServerMetrics.getBytesSent());
            this.merge(errorCount, serverAddress, netServerMetrics.getErrorCount());
        }
        ArrayList<DataPoint> res = new ArrayList<DataPoint>();
        res.addAll(this.gauges("connections", timestamp, connections));
        res.addAll(this.counters("bytesReceived", timestamp, bytesReceived));
        res.addAll(this.counters("bytesSent", timestamp, bytesSent));
        res.addAll(this.counters("errorCount", timestamp, errorCount));
        return res;
    }

    private void merge(Map<SocketAddress, Long> values, SocketAddress serverAddress, Long value) {
        values.merge(serverAddress, value, Long::sum);
    }

    private List<DataPoint> gauges(String id, long timestamp, Map<SocketAddress, Long> values) {
        ArrayList<DataPoint> res = new ArrayList<DataPoint>(values.size());
        values.forEach((address, count) -> {
            String name = this.baseName + address.host() + ":" + address.port() + "." + id;
            res.add(new GaugePoint(name, timestamp, count.longValue()));
        });
        return res;
    }

    private List<DataPoint> counters(String id, long timestamp, Map<SocketAddress, Long> values) {
        ArrayList<DataPoint> res = new ArrayList<DataPoint>(values.size());
        values.forEach((address, count) -> {
            String name = this.baseName + address.host() + ":" + address.port() + "." + id;
            res.add(new CounterPoint(name, timestamp, (long)count));
        });
        return res;
    }

    public void register(NetServerMetricsImpl netServerMetrics) {
        this.metricsSet.add(netServerMetrics);
    }

    public void unregister(NetServerMetricsImpl netServerMetrics) {
        this.metricsSet.remove(netServerMetrics);
    }
}

