/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.impl.DummyVertxMetrics;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.ext.hawkular.MetricsType;
import io.vertx.ext.hawkular.VertxHawkularOptions;
import io.vertx.ext.hawkular.impl.CounterPoint;
import io.vertx.ext.hawkular.impl.DataPoint;
import io.vertx.ext.hawkular.impl.DatagramSocketMetricsImpl;
import io.vertx.ext.hawkular.impl.DatagramSocketMetricsSupplier;
import io.vertx.ext.hawkular.impl.EventBusMetricsImpl;
import io.vertx.ext.hawkular.impl.GaugePoint;
import io.vertx.ext.hawkular.impl.HttpClientMetricsImpl;
import io.vertx.ext.hawkular.impl.HttpClientMetricsSupplier;
import io.vertx.ext.hawkular.impl.HttpServerMetricsImpl;
import io.vertx.ext.hawkular.impl.HttpServerMetricsSupplier;
import io.vertx.ext.hawkular.impl.MetricSupplier;
import io.vertx.ext.hawkular.impl.NamedPoolMetricsSupplier;
import io.vertx.ext.hawkular.impl.NetClientMetricsImpl;
import io.vertx.ext.hawkular.impl.NetClientMetricsSupplier;
import io.vertx.ext.hawkular.impl.NetServerMetricsImpl;
import io.vertx.ext.hawkular.impl.NetServerMetricsSupplier;
import io.vertx.ext.hawkular.impl.PoolMetricsImpl;
import io.vertx.ext.hawkular.impl.Scheduler;
import io.vertx.ext.hawkular.impl.Sender;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class VertxMetricsImpl
extends DummyVertxMetrics {
    private final Vertx vertx;
    private final VertxHawkularOptions options;
    private final Map<MetricsType, MetricSupplier> metricSuppliers;
    private Sender sender;
    private Scheduler scheduler;

    public VertxMetricsImpl(Vertx vertx, VertxHawkularOptions options) {
        this.vertx = vertx;
        this.options = options;
        String prefix = options.getPrefix();
        EnumMap<MetricsType, MetricSupplier> supplierMap = new EnumMap<MetricsType, MetricSupplier>(MetricsType.class);
        if (!options.isMetricsTypeDisabled(MetricsType.HTTP_SERVER)) {
            supplierMap.put(MetricsType.HTTP_SERVER, new HttpServerMetricsSupplier(prefix));
        }
        if (!options.isMetricsTypeDisabled(MetricsType.HTTP_CLIENT)) {
            supplierMap.put(MetricsType.HTTP_CLIENT, new HttpClientMetricsSupplier(prefix));
        }
        if (!options.isMetricsTypeDisabled(MetricsType.NET_SERVER)) {
            supplierMap.put(MetricsType.NET_SERVER, new NetServerMetricsSupplier(prefix));
        }
        if (!options.isMetricsTypeDisabled(MetricsType.NET_CLIENT)) {
            supplierMap.put(MetricsType.NET_CLIENT, new NetClientMetricsSupplier(prefix));
        }
        if (!options.isMetricsTypeDisabled(MetricsType.DATAGRAM_SOCKET)) {
            supplierMap.put(MetricsType.DATAGRAM_SOCKET, new DatagramSocketMetricsSupplier(prefix));
        }
        if (!options.isMetricsTypeDisabled(MetricsType.EVENT_BUS)) {
            supplierMap.put(MetricsType.EVENT_BUS, new EventBusMetricsImpl(prefix));
        }
        if (!options.isMetricsTypeDisabled(MetricsType.NAMED_POOLS)) {
            supplierMap.put(MetricsType.NAMED_POOLS, new NamedPoolMetricsSupplier(prefix));
        }
        this.metricSuppliers = Collections.unmodifiableMap(supplierMap);
    }

    @Override
    public HttpServerMetrics<Long, Void, Void> createMetrics(HttpServer server, SocketAddress localAddress, HttpServerOptions options) {
        HttpServerMetricsSupplier supplier = (HttpServerMetricsSupplier)this.metricSuppliers.get((Object)MetricsType.HTTP_SERVER);
        return supplier != null ? new HttpServerMetricsImpl(localAddress, supplier) : super.createMetrics(server, localAddress, options);
    }

    @Override
    public HttpClientMetrics createMetrics(HttpClient client, HttpClientOptions options) {
        HttpClientMetricsSupplier supplier = (HttpClientMetricsSupplier)this.metricSuppliers.get((Object)MetricsType.HTTP_CLIENT);
        return supplier != null ? new HttpClientMetricsImpl(supplier) : super.createMetrics(client, options);
    }

    @Override
    public TCPMetrics createMetrics(NetServer server, SocketAddress localAddress, NetServerOptions options) {
        NetServerMetricsSupplier supplier = (NetServerMetricsSupplier)this.metricSuppliers.get((Object)MetricsType.NET_SERVER);
        return supplier != null ? new NetServerMetricsImpl(localAddress, supplier) : super.createMetrics(server, localAddress, options);
    }

    @Override
    public TCPMetrics createMetrics(NetClient client, NetClientOptions options) {
        NetClientMetricsSupplier supplier = (NetClientMetricsSupplier)this.metricSuppliers.get((Object)MetricsType.NET_CLIENT);
        return supplier != null ? new NetClientMetricsImpl(supplier) : super.createMetrics(client, options);
    }

    @Override
    public DatagramSocketMetrics createMetrics(DatagramSocket socket, DatagramSocketOptions options) {
        DatagramSocketMetricsSupplier supplier = (DatagramSocketMetricsSupplier)this.metricSuppliers.get((Object)MetricsType.DATAGRAM_SOCKET);
        return supplier != null ? new DatagramSocketMetricsImpl(supplier) : super.createMetrics(socket, options);
    }

    @Override
    public EventBusMetrics createMetrics(EventBus eventBus) {
        EventBusMetrics supplier = (EventBusMetrics)((Object)this.metricSuppliers.get((Object)MetricsType.EVENT_BUS));
        return supplier != null ? supplier : super.createMetrics(eventBus);
    }

    @Override
    public <P> PoolMetrics<?> createMetrics(P pool, String poolType, String poolName, int maxPoolSize) {
        NamedPoolMetricsSupplier supplier = (NamedPoolMetricsSupplier)this.metricSuppliers.get((Object)MetricsType.NAMED_POOLS);
        PoolMetricsImpl poolMetrics = supplier != null ? new PoolMetricsImpl(supplier, poolType, poolName, maxPoolSize) : super.createMetrics(pool, poolType, poolName, maxPoolSize);
        return poolMetrics;
    }

    @Override
    public boolean isMetricsEnabled() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void eventBusInitialized(EventBus bus) {
        Context context = this.vertx.getOrCreateContext();
        this.sender = new Sender(this.vertx, this.options, context);
        this.scheduler = new Scheduler(this.vertx, this.options, context, this.sender);
        this.metricSuppliers.values().forEach(this.scheduler::register);
        if (this.options.isMetricsBridgeEnabled() && this.options.getMetricsBridgeAddress() != null) {
            context.runOnContext(v -> bus.consumer(this.options.getMetricsBridgeAddress(), message -> {
                JsonObject json = (JsonObject)message.body();
                String type = json.getString("type", "");
                String name = json.getString("id");
                long timestamp = json.getLong("timestamp", System.currentTimeMillis());
                DataPoint dataPoint = "counter".equals(type) ? new CounterPoint(name, timestamp, json.getLong("value")) : new GaugePoint(name, timestamp, json.getDouble("value"));
                this.sender.handle(Collections.singletonList(dataPoint));
            }));
        }
    }

    @Override
    public void close() {
        this.metricSuppliers.values().forEach(this.scheduler::unregister);
        this.scheduler.stop();
        this.sender.stop();
    }
}

