/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.ganglia;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import org.hawkular.metrics.clients.ptrans.Configuration;
import org.hawkular.metrics.clients.ptrans.MetricBatcher;
import org.hawkular.metrics.clients.ptrans.backend.RestForwardingHandler;
import org.hawkular.metrics.clients.ptrans.ganglia.UdpGangliaDecoder;

public class GangliaChannelInitializer
extends ChannelInitializer<Channel> {
    private final Configuration configuration;
    private final RestForwardingHandler forwardingHandler;

    public GangliaChannelInitializer(Configuration configuration, RestForwardingHandler forwardingHandler) {
        this.configuration = configuration;
        this.forwardingHandler = forwardingHandler;
    }

    public void initChannel(Channel socketChannel) throws Exception {
        ChannelPipeline pipeline = socketChannel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new UdpGangliaDecoder()});
        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.configuration.getMaximumBatchDelay(), 0, 0)});
        pipeline.addLast(new ChannelHandler[]{new MetricBatcher("ganglia", this.configuration.getMinimumBatchSize())});
        pipeline.addLast(new ChannelHandler[]{this.forwardingHandler});
    }
}

