/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.graphite;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.List;
import org.hawkular.metrics.client.common.SingleMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteEventDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger(GraphiteEventDecoder.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        if (msg.readableBytes() < 1) {
            return;
        }
        String data = msg.toString(CharsetUtil.UTF_8);
        String[] lines = (data = data.trim()).split("\\n");
        if (lines.length == 0) {
            return;
        }
        ArrayList<SingleMetric> metricList = new ArrayList<SingleMetric>(lines.length);
        for (String line : lines) {
            String[] items = line.split(" ");
            if (items.length != 3) {
                logger.debug("Unknown data format for [" + data + "], skipping");
                return;
            }
            long secondsSinceEpoch = Long.parseLong(items[2]);
            long timestamp = secondsSinceEpoch * 1000L;
            SingleMetric metric = new SingleMetric(items[0], timestamp, Double.valueOf(Double.parseDouble(items[1])));
            metricList.add(metric);
        }
        out.add(metricList);
    }
}

