/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans;

import java.util.HashMap;
import java.util.Map;

public enum Service {
    UDP("udp"),
    TCP("tcp"),
    GANGLIA("ganglia"),
    STATSD("statsd"),
    COLLECTD("collectd");

    private final String externalForm;
    private static final Map<String, Service> SERVICES_BY_ID;

    private Service(String externalForm) {
        this.externalForm = externalForm;
    }

    public String getExternalForm() {
        return this.externalForm;
    }

    public static Service findByExternalForm(String externalForm) {
        return SERVICES_BY_ID.get(externalForm);
    }

    static {
        SERVICES_BY_ID = new HashMap<String, Service>();
        for (Service service : Service.values()) {
            SERVICES_BY_ID.put(service.externalForm, service);
        }
    }
}

